package cn.gtmap.gtc.workflow.clients.define.v2;

import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.workflow.domain.define.ProcessModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zhouk
 * @Title: ProcessModelClient
 * @ProjectName workflow
 * @Description: TODO
 * @date 2018/9/2617:31
 */
@FeignClient("${app.services.bpm-define:bpm-define}")
@RequestMapping("define/v2")
public interface ProcessModelClient {

    @RequestMapping(
            value = {"/process-models"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public PageResult<ProcessModel> queryProcessModels(@RequestParam(required = false,value = "filter") String filter,
                                                       @RequestParam(required = false,value = "statusKey") String statusKey,
                                                       @RequestParam(required = false,value = "userName") String userName,
                                                       @RequestParam("modelType") Integer modelType, Pageable pageable);
}
