package cn.gtmap.gtc.workflow.clients.define.v1;


import cn.gtmap.gtc.workflow.domain.define.DefineRoleRelDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 启动的配置的对外接口
 */
@FeignClient("${app.services.bpm-define:bpm-define}")
@RequestMapping("define/v1/define-role")
public interface DefineRoleClient {



    /**
     * 根据流程定义key获取流程的关联
     * @param businessKey
     * @return
     * @throws Exception
     */
    @RequestMapping(
            value = {"/list-by-key"},
            method = {RequestMethod.GET}
    )
    public List<DefineRoleRelDto> getRoleLink(@RequestParam("businessKey") String businessKey);

    @RequestMapping(
            value = {""},
            method = {RequestMethod.POST}
    )
    public void saveRoleLink(@RequestParam("businessKey")String businessKey,@RequestBody List<String> roles);
}
