/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.utils.manager;

import cn.gtmap.gtc.workflow.domain.common.RequestCondition;
import cn.gtmap.gtc.workflow.enums.manage.ProcQuerykey;
import cn.gtmap.gtc.workflow.enums.manage.ProcStatusQueryEqEnum;
import cn.gtmap.gtc.workflow.enums.manage.QueryJudge;
import cn.gtmap.gtc.workflow.enums.manage.TaskQueryKey;
import cn.gtmap.gtc.workflow.enums.manage.TaskStatusQueryEqEnum;
import cn.gtmap.gtc.workflow.utils.manager.DatabaseTypeUtils;
import cn.gtmap.gtc.workflow.utils.manager.ProjectExtendConfigUtils;
import cn.gtmap.gtc.workflow.utils.manager.RequestKeyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RequestConditionUtils {
    private static final Logger logger = LoggerFactory.getLogger(RequestConditionUtils.class);

    public static String spliceTaskExtendSql(String taskPrefix, String taskSuffix, String defaultOrder, List<RequestCondition> requestConditions, Map<String, Object> params, String databaseType) {
        return RequestConditionUtils.spliceTaskExtendSql(taskPrefix, taskSuffix, defaultOrder, " where  1=1 ", requestConditions, params, databaseType, null);
    }

    public static String spliceTaskExtendSql(String taskPrefix, String taskSuffix, String defaultOrder, String whereCommonSql, List<RequestCondition> requestConditions, Map<String, Object> params, String databaseType, String whereBaseSql) {
        if (CollectionUtils.isNotEmpty(requestConditions)) {
            String whereOrSqlStr;
            StringBuilder whereSql = new StringBuilder();
            StringBuilder orderSql = new StringBuilder();
            HashSet whereOrSql = new HashSet();
            requestConditions.forEach(requestCondition -> {
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)requestCondition.getRequestKey())) {
                    boolean isExtend = true;
                    if (RequestKeyUtils.isTaskContains(requestCondition.getRequestKey())) {
                        isExtend = false;
                    }
                    if (QueryJudge.EQUALS.value().equals(requestCondition.getRequestJudge())) {
                        whereSql.append(RequestConditionUtils.getCommonOperator(requestCondition, "=", isExtend, true, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.NOT_EQUALS.value())) {
                        whereSql.append(RequestConditionUtils.getCommonOperator(requestCondition, "!=", isExtend, true, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_GT.value())) {
                        whereSql.append(RequestConditionUtils.getCommonOperator(requestCondition, ">", isExtend, true, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_EGT.value())) {
                        whereSql.append(RequestConditionUtils.getCommonOperator(requestCondition, ">=", isExtend, true, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_LT.value())) {
                        whereSql.append(RequestConditionUtils.getCommonOperator(requestCondition, "<", isExtend, true, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_ELT.value())) {
                        whereSql.append(RequestConditionUtils.getCommonOperator(requestCondition, "<=", isExtend, true, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.LIKE.value())) {
                        whereSql.append(RequestConditionUtils.getCommonLike(requestCondition, isExtend, true));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.IN.value())) {
                        whereSql.append(RequestConditionUtils.getCommonIn(requestCondition, isExtend, true));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.SPECIAL.value())) {
                        whereSql.append(RequestConditionUtils.getCommonSpecialSql(requestCondition));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.ORDER.value())) {
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderSql.toString())) {
                            orderSql.append(" ," + RequestConditionUtils.getCommonOrder(requestCondition, isExtend, true));
                        } else {
                            orderSql.append(RequestConditionUtils.getCommonOrder(requestCondition, isExtend, true));
                        }
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.OR_EQUALS.value())) {
                        whereOrSql.add(RequestConditionUtils.getCommonOrOperator(requestCondition, "=", isExtend, true, databaseType, whereBaseSql));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.OR_LIKE.value())) {
                        whereOrSql.add(RequestConditionUtils.getCommonOrLike(requestCondition, isExtend, true, whereBaseSql));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.OR_IN.value())) {
                        whereOrSql.add(RequestConditionUtils.getCommonOrIn(requestCondition, isExtend, true, whereBaseSql));
                    }
                    if (!requestCondition.getRequestJudge().equals(QueryJudge.LIKE.value()) && !requestCondition.getRequestJudge().equals(QueryJudge.ORDER.value())) {
                        params.put(requestCondition.getRequestKey(), requestCondition.getRequestValue());
                    }
                }
            });
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orderSql.toString())) {
                orderSql.append(defaultOrder);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(whereOrSqlStr = StringUtils.collectionToDelimitedString(whereOrSql, (String)" or ")))) {
                whereOrSqlStr = " and ( " + whereOrSqlStr + " )";
            }
            String sql = taskPrefix + RequestConditionUtils.getCustomCloumnSql() + taskSuffix + whereCommonSql + whereSql + whereOrSqlStr + " order by " + orderSql;
            return sql;
        }
        return taskPrefix + RequestConditionUtils.getCustomCloumnSql() + taskSuffix + whereCommonSql + " order by " + defaultOrder;
    }

    public static String spliceProcessExtendSql(String processPrefix, String processSuffix, String defaultOrder, String processWhere, List<RequestCondition> requestConditions, Map<String, Object> params, String databaseType, String whereBaseSql) {
        if (CollectionUtils.isNotEmpty(requestConditions)) {
            String whereOrSqlStr;
            StringBuilder whereSql = new StringBuilder();
            StringBuilder orderSql = new StringBuilder();
            HashSet whereOrSql = new HashSet();
            requestConditions.forEach(requestCondition -> {
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)requestCondition.getRequestKey())) {
                    boolean isExtend = true;
                    if (RequestKeyUtils.isProcContains(requestCondition.getRequestKey())) {
                        isExtend = false;
                    }
                    if (requestCondition.getRequestJudge().equals(QueryJudge.EQUALS.value())) {
                        whereSql.append(RequestConditionUtils.getCommonOperator(requestCondition, "=", isExtend, false, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.NOT_EQUALS.value())) {
                        whereSql.append(RequestConditionUtils.getCommonOperator(requestCondition, "!=", isExtend, false, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_GT.value())) {
                        whereSql.append(RequestConditionUtils.getCommonOperator(requestCondition, ">", isExtend, false, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_EGT.value())) {
                        whereSql.append(RequestConditionUtils.getCommonOperator(requestCondition, ">=", isExtend, false, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_LT.value())) {
                        whereSql.append(RequestConditionUtils.getCommonOperator(requestCondition, "<", isExtend, false, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_ELT.value())) {
                        whereSql.append(RequestConditionUtils.getCommonOperator(requestCondition, "<=", isExtend, false, databaseType));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.LIKE.value())) {
                        whereSql.append(RequestConditionUtils.getCommonLike(requestCondition, isExtend, false));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.IN.value())) {
                        whereSql.append(RequestConditionUtils.getCommonIn(requestCondition, isExtend, false));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.SPECIAL.value())) {
                        whereSql.append(RequestConditionUtils.getCommonSpecialSql(requestCondition));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.ORDER.value())) {
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderSql.toString())) {
                            orderSql.append(" ," + RequestConditionUtils.getCommonOrder(requestCondition, isExtend, false));
                        } else {
                            orderSql.append(RequestConditionUtils.getCommonOrder(requestCondition, isExtend, false));
                        }
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.OR_EQUALS.value())) {
                        whereOrSql.add(RequestConditionUtils.getCommonOrOperator(requestCondition, "=", isExtend, false, databaseType, whereBaseSql));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.OR_LIKE.value())) {
                        whereOrSql.add(RequestConditionUtils.getCommonOrLike(requestCondition, isExtend, false, whereBaseSql));
                    } else if (requestCondition.getRequestJudge().equals(QueryJudge.OR_IN.value())) {
                        whereOrSql.add(RequestConditionUtils.getCommonOrIn(requestCondition, isExtend, false, whereBaseSql));
                    }
                    if (!requestCondition.getRequestJudge().equals(QueryJudge.LIKE.value()) && !requestCondition.getRequestJudge().equals(QueryJudge.ORDER.value())) {
                        params.put(requestCondition.getRequestKey(), requestCondition.getRequestValue());
                    }
                }
            });
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orderSql.toString())) {
                orderSql.append(defaultOrder);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(whereOrSqlStr = StringUtils.collectionToDelimitedString(whereOrSql, (String)" or ")))) {
                whereOrSqlStr = " and ( " + whereOrSqlStr + " )";
            }
            String sql = processPrefix + RequestConditionUtils.getCustomCloumnSql() + processSuffix + processWhere + whereSql + whereOrSqlStr + " order by " + orderSql;
            return sql;
        }
        return processPrefix + RequestConditionUtils.getCustomCloumnSql() + processSuffix + processWhere + " order by " + defaultOrder;
    }

    private static String getCommonOrOperator(RequestCondition requestCondition, String Operator, boolean isExtend, boolean isTask, String databaseType, String whereBaseSql) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)whereBaseSql)) {
            return RequestConditionUtils.getCommonOperator(requestCondition, Operator, isExtend, isTask, databaseType, null) + whereBaseSql;
        }
        return RequestConditionUtils.getCommonOperator(requestCondition, Operator, isExtend, isTask, databaseType, null);
    }

    private static String getCommonOperator(RequestCondition requestCondition, String Operator, boolean isExtend, boolean isTask, String databaseType) {
        return RequestConditionUtils.getCommonOperator(requestCondition, Operator, isExtend, isTask, databaseType, "and");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getCommonOperator(RequestCondition requestCondition, String Operator, boolean isExtend, boolean isTask, String databaseType, String link) {
        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)requestCondition.getRequestKey())) throw new NullPointerException("RequestKey of RequestCondition is null!");
        StringBuilder sql = null;
        sql = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)link) ? new StringBuilder() : new StringBuilder(" ").append(link).append(" ");
        boolean isDate = false;
        if (isExtend) {
            String extendCloumnName;
            if (DatabaseTypeUtils.isDateOfCloumnType(databaseType, requestCondition.getRequestKey())) {
                isDate = true;
            }
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(extendCloumnName = ProjectExtendConfigUtils.ProjectExtendConfigMap.get(requestCondition.getRequestKey())))) throw new NullPointerException(requestCondition.getRequestKey() + "  \u5728\u9879\u76ee\u81ea\u5b9a\u4e49\u5c5e\u6027\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5217\u540d\uff01");
            sql.append(extendCloumnName);
        } else {
            if (DatabaseTypeUtils.isDateOfCommonCloumnType(requestCondition.getRequestKey())) {
                isDate = true;
            }
            if (isTask) {
                sql.append(RequestKeyUtils.getTaskcolumn(requestCondition.getRequestKey()));
            } else {
                sql.append(RequestKeyUtils.getProccolumn(requestCondition.getRequestKey()));
            }
        }
        sql.append(" ");
        sql.append(Operator);
        sql.append(" ");
        if (isDate) {
            String key = requestCondition.getRequestKey() + "_" + requestCondition.getRequestJudge();
            requestCondition.setRequestKey(key);
            String cloumnName = "#{" + key + "}";
            sql.append(DatabaseTypeUtils.toDateCloumnType(databaseType, cloumnName));
            return sql.toString();
        } else {
            sql.append("#{");
            sql.append(requestCondition.getRequestKey());
            sql.append("}");
        }
        return sql.toString();
    }

    private static String getCommonOrLike(RequestCondition requestCondition, boolean isExtend, boolean isTask, String whereBaseSql) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)whereBaseSql)) {
            return RequestConditionUtils.getCommonLike(requestCondition, isExtend, isTask, null) + whereBaseSql;
        }
        return RequestConditionUtils.getCommonLike(requestCondition, isExtend, isTask, null);
    }

    private static String getCommonLike(RequestCondition requestCondition, boolean isExtend, boolean isTask) {
        return RequestConditionUtils.getCommonLike(requestCondition, isExtend, isTask, "and");
    }

    private static String getCommonLike(RequestCondition requestCondition, boolean isExtend, boolean isTask, String link) {
        try {
            if (requestCondition.getRequestValue() instanceof String) {
                StringBuilder sql = null;
                sql = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)link) ? new StringBuilder() : new StringBuilder(" ").append(link).append(" ");
                if (isExtend) {
                    sql.append(ProjectExtendConfigUtils.ProjectExtendConfigMap.get(requestCondition.getRequestKey()));
                } else if (isTask) {
                    sql.append(RequestKeyUtils.getTaskcolumn(requestCondition.getRequestKey()));
                } else {
                    sql.append(RequestKeyUtils.getProccolumn(requestCondition.getRequestKey()));
                }
                sql.append(" like ");
                sql.append("'%");
                sql.append(requestCondition.getRequestValue());
                sql.append("%'");
                logger.debug("CommonLike sql==== {}", (Object)sql.toString());
                return sql.toString();
            }
            throw new Exception("CommonLike RequestValue is not String");
        }
        catch (Exception e) {
            logger.debug("CommonLike RequestValue is not String", (Object)e.getMessage());
            return "";
        }
    }

    private static String getCommonOrIn(RequestCondition requestCondition, boolean isExtend, boolean isTask, String whereBaseSql) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)whereBaseSql)) {
            return RequestConditionUtils.getCommonIn(requestCondition, isExtend, isTask, null) + whereBaseSql;
        }
        return RequestConditionUtils.getCommonIn(requestCondition, isExtend, isTask, null);
    }

    private static String getCommonIn(RequestCondition requestCondition, boolean isExtend, boolean isTask) {
        return RequestConditionUtils.getCommonIn(requestCondition, isExtend, isTask, "and");
    }

    private static String getCommonIn(RequestCondition requestCondition, boolean isExtend, boolean isTask, String link) {
        try {
            if (null != requestCondition.getRequestValue() && requestCondition.getRequestValue() instanceof List) {
                StringBuilder sql = null;
                sql = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)link) ? new StringBuilder() : new StringBuilder(" ").append(link).append(" ");
                if (isExtend) {
                    sql.append(ProjectExtendConfigUtils.ProjectExtendConfigMap.get(requestCondition.getRequestKey()));
                } else if (isTask) {
                    sql.append(RequestKeyUtils.getTaskcolumn(requestCondition.getRequestKey()));
                } else {
                    sql.append(RequestKeyUtils.getProccolumn(requestCondition.getRequestKey()));
                }
                sql.append(" in (");
                HashSet inList = new HashSet((List)requestCondition.getRequestValue());
                String instr = StringUtils.collectionToDelimitedString(inList, (String)",", (String)"'", (String)"'");
                sql.append(instr);
                sql.append(" )");
                return sql.toString();
            }
            throw new Exception(requestCondition.getRequestKey() + "in \u8303\u56f4\u7684\u5c5e\u6027\u503c\u4e0d\u4e3a List\u7c7b");
        }
        catch (Exception e) {
            logger.debug("getCommonIn \u8303\u56f4\u7684\u5c5e\u6027\u503c : {}", (Object)e.getMessage());
            return "";
        }
    }

    private static String getCommonOrder(RequestCondition requestCondition, boolean isExtend, boolean isTask) {
        try {
            if (null != requestCondition.getRequestValue()) {
                StringBuilder sql = new StringBuilder();
                if (isExtend) {
                    sql.append(ProjectExtendConfigUtils.ProjectExtendConfigMap.get(requestCondition.getRequestKey()));
                } else if (isTask) {
                    sql.append(RequestKeyUtils.getTaskcolumn(requestCondition.getRequestKey()));
                } else {
                    sql.append(RequestKeyUtils.getProccolumn(requestCondition.getRequestKey()));
                }
                sql.append(" ");
                sql.append(requestCondition.getRequestValue());
                return sql.toString();
            }
            throw new Exception(requestCondition.getRequestKey() + " Order \u5c5e\u6027\u503c\u4e0d\u4e3a null");
        }
        catch (Exception e) {
            logger.debug("getCommonOrder \u5f02\u5e38 : {}", (Object)e.getMessage());
            return "";
        }
    }

    public static String getCustomCloumnSql() {
        Map<String, String> configMap = ProjectExtendConfigUtils.ProjectExtendConfigMap;
        if (configMap.size() > 0) {
            StringBuilder customSql = new StringBuilder();
            configMap.keySet().forEach(key -> {
                customSql.append(", ");
                customSql.append("ACT_ST_PRO_REL.");
                customSql.append((String)configMap.get(key));
                customSql.append(" \"");
                customSql.append((String)key);
                customSql.append("\" ");
            });
            return customSql.toString();
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getCommonSpecialSql(RequestCondition requestCondition) {
        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)requestCondition.getRequestKey())) return "";
        StringBuilder sql = new StringBuilder();
        if (requestCondition.getRequestKey().equals(ProcQuerykey.TASK_ASSIGIN.getValue())) {
            sql.append("  AND ahpi.PROC_INST_ID_ in ( ");
            sql.append("SELECT PROC_INST_ID_ FROM ACT_HI_TASKINST WHERE ASSIGNEE_ = #{taskAssigin}");
            sql.append("   )");
            return sql.toString();
        } else if (requestCondition.getRequestKey().equals(TaskQueryKey.TASK_STATUS.value())) {
            String type = requestCondition.getRequestValue().toString();
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)type)) throw new NullPointerException("\u4efb\u52a1\u72b6\u6001\u7279\u6b8a\u67e5\u8be2\u7684\u72b6\u6001\u7c7b\u578b\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
            if (type.equals(TaskStatusQueryEqEnum.NORMAL.getValue())) {
                sql.append(" AND ACT_ST_TASK.TASK_STATUS=1 ");
                sql.append(" AND ACT_ST_TASK.TASK_TIMEOUT_STATUS=0 ");
                sql.append(" AND ACT_ST_TASK.BACK_STATUS is NULL ");
                return sql.toString();
            } else if (type.equals(TaskStatusQueryEqEnum.BACK.getValue())) {
                sql.append(" AND ACT_ST_TASK.BACK_STATUS=1 ");
                return sql.toString();
            } else if (type.equals(TaskStatusQueryEqEnum.BACKED.getValue())) {
                sql.append(" AND ACT_ST_TASK.BACK_STATUS=2 ");
                return sql.toString();
            } else if (type.equals(TaskStatusQueryEqEnum.HANG.getValue())) {
                sql.append(" AND ACT_ST_TASK.TASK_STATUS=2 ");
                return sql.toString();
            } else {
                if (!type.equals(TaskStatusQueryEqEnum.TIMEOUT.getValue())) return sql.toString();
                sql.append(" AND ACT_ST_TASK.TASK_TIMEOUT_STATUS=1 ");
            }
            return sql.toString();
        } else {
            String instr;
            HashSet inList;
            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)ProcQuerykey.PROC_All_STATUS.getValue(), (CharSequence)requestCondition.getRequestKey())) return sql.toString();
            if (!(requestCondition.getRequestValue() instanceof List)) throw new NullPointerException("\u6d41\u7a0b\u72b6\u6001\u7684\u5c5e\u6027value \u4e0d\u662fList\u7c7b\u578b\uff01");
            List statusList = (List)requestCondition.getRequestValue();
            if (!CollectionUtils.isNotEmpty((Collection)statusList)) return sql.toString();
            ArrayList<Integer> procStatusList = new ArrayList<Integer>();
            ArrayList<Integer> priorityList = new ArrayList<Integer>();
            if (statusList.contains(ProcStatusQueryEqEnum.RUNNING.getValue())) {
                procStatusList.add(1);
            } else if (statusList.contains(ProcStatusQueryEqEnum.END.getValue())) {
                procStatusList.add(2);
            } else if (statusList.contains(ProcStatusQueryEqEnum.SUSPEND.getValue())) {
                procStatusList.add(3);
            } else if (statusList.contains(ProcStatusQueryEqEnum.ABANDON.getValue())) {
                procStatusList.add(4);
            } else if (statusList.contains(ProcStatusQueryEqEnum.ORDINARY.getValue())) {
                priorityList.add(100);
            } else if (statusList.contains(ProcStatusQueryEqEnum.URGENT.getValue())) {
                priorityList.add(150);
            } else if (statusList.contains(ProcStatusQueryEqEnum.EXTRA_URGENT.getValue())) {
                priorityList.add(200);
            }
            if (CollectionUtils.isNotEmpty(procStatusList)) {
                sql.append(" AND ACT_ST_PROC.PROC_STATUS ");
                sql.append(" in (");
                inList = new HashSet(procStatusList);
                instr = StringUtils.collectionToDelimitedString(inList, (String)",", (String)"'", (String)"'");
                sql.append(instr);
                sql.append(" )");
            }
            if (!CollectionUtils.isNotEmpty(priorityList)) return sql.toString();
            sql.append(" AND ACT_ST_PROC.PRIORITY ");
            sql.append(" in (");
            inList = new HashSet(priorityList);
            instr = StringUtils.collectionToDelimitedString(inList, (String)",", (String)"'", (String)"'");
            sql.append(instr);
            sql.append(" )");
        }
        return sql.toString();
    }

    public static void handleCompleteTaskRequest(List<RequestCondition> requestConditions, Map<String, Object> params, String databaseType, String whereBaseSql) {
        if (CollectionUtils.isNotEmpty(requestConditions)) {
            HashMap<String, String> sqlWhereMap = new HashMap<String, String>();
            HashMap sqlWhereOrMap = new HashMap();
            for (RequestCondition requestCondition : requestConditions) {
                String tableName;
                HashSet<String> oldwhereOrSql;
                RequestConditionUtils.checkRequestCondition(requestCondition);
                String requestKey = requestCondition.getRequestKey();
                boolean isExtend = true;
                if (RequestKeyUtils.isTaskContains(requestCondition.getRequestKey())) {
                    isExtend = false;
                } else if (ProjectExtendConfigUtils.ProjectExtendConfigMap.containsKey(requestCondition.getRequestKey())) {
                    isExtend = true;
                } else {
                    throw new NullPointerException(requestCondition.getRequestKey() + " \u5728TaskQueryKey \u548c \u6269\u5c55\u5c5e\u6027\u4e2d\u90fd\u627e\u4e0d\u5230,\u8bf7\u68c0\u67e5key!");
                }
                String oldwhereSql = (String)sqlWhereMap.get(RequestKeyUtils.getTaskName(requestCondition.getRequestKey()));
                oldwhereSql = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)oldwhereSql) ? oldwhereSql : "";
                String whereSql = RequestConditionUtils.getCommomTableWhereSql(requestCondition, params, isExtend, true, databaseType);
                sqlWhereMap.put(RequestKeyUtils.getTaskName(requestKey), oldwhereSql + whereSql);
                if (!params.containsKey("actHiTaskinstOrderSql")) {
                    params.put("actHiTaskinstOrderSql", RequestConditionUtils.getCommomTasktableOrderSql(requestCondition));
                }
                if (CollectionUtils.isEmpty((Collection)(oldwhereOrSql = (HashSet<String>)sqlWhereOrMap.get(tableName = RequestKeyUtils.getTaskName(requestCondition.getRequestKey()))))) {
                    oldwhereOrSql = new HashSet<String>();
                }
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)tableName, (CharSequence)"taskWhereSql")) {
                    oldwhereOrSql.add(RequestConditionUtils.getCommomTableWhereOrSql(requestCondition, params, isExtend, true, databaseType, whereBaseSql));
                } else {
                    oldwhereOrSql.add(RequestConditionUtils.getCommomTableWhereOrSql(requestCondition, params, isExtend, true, databaseType, null));
                }
                sqlWhereOrMap.put(RequestKeyUtils.getTaskName(requestKey), oldwhereOrSql);
            }
            if (params.get("actHiTaskinstOrderSql") != null && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)params.get("actHiTaskinstOrderSql").toString())) {
                params.remove("actHiTaskinstOrderSql");
            }
            params.put("dynamicCloumn", RequestConditionUtils.getCustomCloumnSql());
            for (String key : sqlWhereOrMap.keySet()) {
                Set whereOrSql = (Set)sqlWhereOrMap.get(key);
                String sqlStr = StringUtils.collectionToDelimitedString((Collection)whereOrSql, (String)" or ");
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sqlStr)) continue;
                sqlStr = " and ( " + sqlStr + " )";
                String sql = (String)sqlWhereMap.get(key);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sql)) {
                    sqlWhereMap.put(key, sql + sqlStr);
                    continue;
                }
                sqlWhereMap.put(key, sqlStr);
            }
            params.putAll(sqlWhereMap);
        } else {
            params.put("dynamicCloumn", RequestConditionUtils.getCustomCloumnSql());
        }
    }

    public static void handleProcRequest(List<RequestCondition> requestConditions, Map<String, Object> params, String databaseType) {
        if (CollectionUtils.isNotEmpty(requestConditions)) {
            HashMap<String, String> sqlWhereMap = new HashMap<String, String>();
            HashMap<String, HashSet<String>> sqlWhereOrMap = new HashMap<String, HashSet<String>>();
            for (RequestCondition requestCondition : requestConditions) {
                String tableName;
                HashSet<String> oldwhereOrSql;
                RequestConditionUtils.checkRequestCondition(requestCondition);
                String requestKey = requestCondition.getRequestKey();
                boolean isExtend = true;
                if (RequestKeyUtils.isProcContains(requestCondition.getRequestKey())) {
                    isExtend = false;
                } else if (ProjectExtendConfigUtils.ProjectExtendConfigMap.containsKey(requestCondition.getRequestKey())) {
                    isExtend = true;
                } else {
                    throw new NullPointerException(requestCondition.getRequestKey() + " \u5728ProcQuerykey \u548c \u6269\u5c55\u5c5e\u6027\u4e2d\u90fd\u627e\u4e0d\u5230,\u8bf7\u68c0\u67e5key!");
                }
                String oldwhereSql = (String)sqlWhereMap.get(RequestKeyUtils.getProcName(requestCondition.getRequestKey()));
                oldwhereSql = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)oldwhereSql) ? oldwhereSql : "";
                String whereSql = RequestConditionUtils.getCommomTableWhereSql(requestCondition, params, isExtend, false, databaseType);
                sqlWhereMap.put(RequestKeyUtils.getProcName(requestKey), oldwhereSql + whereSql);
                if (!params.containsKey("actHiProcinstOrderSql")) {
                    params.put("actHiProcinstOrderSql", RequestConditionUtils.getCommomProctableOrderSql(requestCondition));
                }
                if (CollectionUtils.isEmpty((Collection)(oldwhereOrSql = (HashSet<String>)sqlWhereOrMap.get(tableName = RequestKeyUtils.getTaskName(requestCondition.getRequestKey()))))) {
                    oldwhereOrSql = new HashSet<String>();
                }
                oldwhereOrSql.add(RequestConditionUtils.getCommomTableWhereOrSql(requestCondition, params, isExtend, true, databaseType, null));
                sqlWhereOrMap.put(RequestKeyUtils.getTaskName(requestKey), oldwhereOrSql);
            }
            params.put("dynamicCloumn", RequestConditionUtils.getCustomCloumnSql());
            for (String key : sqlWhereOrMap.keySet()) {
                Set whereOrSqlSet = (Set)sqlWhereOrMap.get(key);
                String sqlStr = StringUtils.collectionToDelimitedString((Collection)whereOrSqlSet, (String)" or ");
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sqlStr)) continue;
                sqlStr = " and ( " + sqlStr + " )";
                String sql = (String)sqlWhereMap.get(key);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sql)) {
                    sqlWhereMap.put(key, sql + sqlStr);
                    continue;
                }
                sqlWhereMap.put(key, sqlStr);
            }
            params.putAll(sqlWhereMap);
        } else {
            params.put("dynamicCloumn", RequestConditionUtils.getCustomCloumnSql());
        }
    }

    private static String getCommomTableWhereSql(RequestCondition requestCondition, Map<String, Object> params, boolean isExtend, boolean isTask, String databaseType) {
        StringBuilder whereSql = new StringBuilder();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)requestCondition.getRequestKey())) {
            if (QueryJudge.EQUALS.value().equals(requestCondition.getRequestJudge())) {
                whereSql.append(RequestConditionUtils.getCommonOperator(requestCondition, "=", isExtend, isTask, databaseType));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.NOT_EQUALS.value())) {
                whereSql.append(RequestConditionUtils.getCommonOperator(requestCondition, "!=", isExtend, isTask, databaseType));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_GT.value())) {
                whereSql.append(RequestConditionUtils.getCommonOperator(requestCondition, ">", isExtend, isTask, databaseType));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_EGT.value())) {
                whereSql.append(RequestConditionUtils.getCommonOperator(requestCondition, ">=", isExtend, isTask, databaseType));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_LT.value())) {
                whereSql.append(RequestConditionUtils.getCommonOperator(requestCondition, "<", isExtend, isTask, databaseType));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.DATE_ELT.value())) {
                whereSql.append(RequestConditionUtils.getCommonOperator(requestCondition, "<=", isExtend, isTask, databaseType));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.LIKE.value())) {
                whereSql.append(RequestConditionUtils.getCommonLike(requestCondition, isExtend, isTask));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.IN.value())) {
                whereSql.append(RequestConditionUtils.getCommonIn(requestCondition, isExtend, isTask));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.SPECIAL.value())) {
                whereSql.append(RequestConditionUtils.getCommonSpecialSql(requestCondition));
            }
            if (!requestCondition.getRequestJudge().equals(QueryJudge.LIKE.value()) && !requestCondition.getRequestJudge().equals(QueryJudge.ORDER.value())) {
                params.put(requestCondition.getRequestKey(), requestCondition.getRequestValue());
            }
        }
        return whereSql.toString();
    }

    private static String getCommomTableWhereOrSql(RequestCondition requestCondition, Map<String, Object> params, boolean isExtend, boolean isTask, String databaseType, String whereBaseSql) {
        StringBuilder whereOrSql = new StringBuilder();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)requestCondition.getRequestKey())) {
            if (requestCondition.getRequestJudge().equals(QueryJudge.OR_EQUALS.value())) {
                whereOrSql.append(RequestConditionUtils.getCommonOrOperator(requestCondition, "=", isExtend, false, databaseType, whereBaseSql));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.OR_LIKE.value())) {
                whereOrSql.append(RequestConditionUtils.getCommonOrLike(requestCondition, isExtend, false, whereBaseSql));
            } else if (requestCondition.getRequestJudge().equals(QueryJudge.OR_IN.value())) {
                whereOrSql.append(RequestConditionUtils.getCommonOrIn(requestCondition, isExtend, false, whereBaseSql));
            }
        }
        return whereOrSql.toString();
    }

    private static String getCommomTasktableOrderSql(RequestCondition requestCondition) {
        String orderSql = null;
        if (QueryJudge.ORDER.value().equals(requestCondition.getRequestJudge())) {
            if (TaskQueryKey.START_TIME_TODO.value().equals(requestCondition.getRequestKey())) {
                orderSql = " order by  task.CREATE_TIME_ " + requestCondition.getRequestValue().toString();
            } else if (TaskQueryKey.START_TIME_COMPLTETE.value().equals(requestCondition.getRequestKey())) {
                orderSql = " order by task.START_TIME_ " + requestCondition.getRequestValue().toString();
            } else if (TaskQueryKey.END_TIME.value().equals(requestCondition.getRequestKey())) {
                orderSql = " order by task.END_TIME_ " + requestCondition.getRequestValue().toString();
            } else {
                throw new NullPointerException("\u4efb\u52a1\u6392\u5e8fkey \u9650\u5236\u4e3a \u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\uff01");
            }
        }
        return orderSql;
    }

    private static String getCommomProctableOrderSql(RequestCondition requestCondition) {
        String orderSql = null;
        if (QueryJudge.ORDER.value().equals(requestCondition.getRequestJudge())) {
            if (ProcQuerykey.STARTTIME.getValue().equals(requestCondition.getRequestKey())) {
                orderSql = " order by hpi.CREATE_TIME_ " + requestCondition.getRequestValue().toString();
            } else if (ProcQuerykey.ENDTIME.getValue().equals(requestCondition.getRequestKey())) {
                orderSql = " order by hpi.START_TIME_ " + requestCondition.getRequestValue().toString();
            } else {
                throw new NullPointerException("\u4efb\u52a1\u6392\u5e8fkey \u9650\u5236\u4e3a \u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\uff01");
            }
        }
        return orderSql;
    }

    private static void checkRequestCondition(RequestCondition requestCondition) {
        if (requestCondition == null) {
            throw new NullPointerException("requestCondition is null !");
        }
        if (requestCondition != null && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)requestCondition.getRequestKey())) {
            throw new NullPointerException("RequestKey is null !");
        }
        if (requestCondition != null && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)requestCondition.getRequestJudge())) {
            throw new NullPointerException("RequestJudge is null !");
        }
        if (requestCondition != null && requestCondition.getRequestValue() == null) {
            throw new NullPointerException("RequestValue is null !");
        }
    }
}

