/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.utils.manager;

import cn.gtmap.gtc.workflow.domain.common.RequestCondition;
import cn.gtmap.gtc.workflow.enums.manage.QueryJudge;
import cn.gtmap.gtc.workflow.enums.manage.TaskQueryKey;
import cn.gtmap.gtc.workflow.enums.manage.TaskStatusQueryEqEnum;
import cn.gtmap.gtc.workflow.utils.manager.DatabaseTypeUtils;
import cn.gtmap.gtc.workflow.utils.manager.RequestKeyUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class EsSearchJsonUtils {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final Logger logger = LoggerFactory.getLogger(EsSearchJsonUtils.class);

    public static JSONObject spliceBoolCommomJson(List<RequestCondition> requestConditions, final JSONObject whereJson, String databaseType) {
        JSONObject queryJson = new JSONObject();
        final JSONArray andJson = new JSONArray();
        final JSONArray notJson = new JSONArray();
        JSONArray orderJson = new JSONArray();
        if (!CollectionUtils.isEmpty(requestConditions)) {
            requestConditions.forEach(requestCondition -> {
                if (!org.springframework.util.StringUtils.isEmpty((Object)requestCondition.getRequestJudge())) {
                    EsSearchJsonUtils.handleValueAndKey(requestCondition, databaseType);
                    if (QueryJudge.EQUALS.value().equals(requestCondition.getRequestJudge())) {
                        andJson.add((Object)EsSearchJsonUtils.spliceCommomJson(requestCondition, "term"));
                    } else if (QueryJudge.LIKE.value().equals(requestCondition.getRequestJudge())) {
                        andJson.add((Object)EsSearchJsonUtils.spliceLikeJson(requestCondition));
                    } else if (QueryJudge.IN.value().equals(requestCondition.getRequestJudge())) {
                        andJson.add((Object)EsSearchJsonUtils.spliceCommomJson(requestCondition, "terms"));
                    } else if (QueryJudge.DATE_LT.value().equals(requestCondition.getRequestJudge())) {
                        andJson.add((Object)EsSearchJsonUtils.spliceRanageJson(requestCondition, QueryJudge.DATE_LT.value()));
                    } else if (QueryJudge.DATE_ELT.value().equals(requestCondition.getRequestJudge())) {
                        andJson.add((Object)EsSearchJsonUtils.spliceRanageJson(requestCondition, "lte"));
                    } else if (QueryJudge.DATE_EGT.value().equals(requestCondition.getRequestJudge())) {
                        andJson.add((Object)EsSearchJsonUtils.spliceRanageJson(requestCondition, "gte"));
                    } else if (QueryJudge.DATE_GT.value().equals(requestCondition.getRequestJudge())) {
                        andJson.add((Object)EsSearchJsonUtils.spliceRanageJson(requestCondition, QueryJudge.DATE_GT.value()));
                    } else if (QueryJudge.ORDER.value().equals(requestCondition.getRequestJudge())) {
                        orderJson.add((Object)EsSearchJsonUtils.spliceOrderJson(requestCondition));
                    } else if (QueryJudge.NOT_EQUALS.value().equals(requestCondition.getRequestJudge())) {
                        notJson.add((Object)EsSearchJsonUtils.spliceCommomJson(requestCondition, "term"));
                    } else if (QueryJudge.SPECIAL.value().equals(requestCondition.getRequestJudge())) {
                        EsSearchJsonUtils.spliceSpecialCommomJSON(requestCondition, andJson, notJson);
                    }
                } else {
                    throw new NullPointerException(requestCondition.getRequestKey() + " \u5224\u65ad\u6761\u4ef6\u4e0d\u53ef\u4e3a\u7a7a!");
                }
            });
        }
        queryJson.put("query", (Object)new JSONObject(){
            {
                this.put("bool", new JSONObject(){
                    {
                        if (andJson.size() > 0) {
                            this.put("must", andJson);
                        }
                        if (notJson.size() > 0) {
                            this.put("must_not", notJson);
                        }
                        if (whereJson != null && !whereJson.isEmpty()) {
                            this.put("filter", whereJson);
                        }
                    }
                });
            }
        });
        if (orderJson.size() > 0) {
            queryJson.put("sort", (Object)orderJson);
        }
        return queryJson;
    }

    private static void handleValueAndKey(RequestCondition requestCondition, String databaseType) {
        Logger logger = LoggerFactory.getLogger(EsSearchJsonUtils.class);
        if ("string".equalsIgnoreCase(RequestKeyUtils.getTaskKeyType.get(requestCondition.getRequestKey())) || "string".equalsIgnoreCase(RequestKeyUtils.getProcKeyType.get(requestCondition.getRequestKey())) || "string".equalsIgnoreCase(DatabaseTypeUtils.boolDataType(requestCondition.getRequestKey(), databaseType))) {
            requestCondition.setRequestKey(requestCondition.getRequestKey() + ".keyword");
        } else if (!"number".equalsIgnoreCase(RequestKeyUtils.getTaskKeyType.get(requestCondition.getRequestKey())) && !"number".equalsIgnoreCase(RequestKeyUtils.getProcKeyType.get(requestCondition.getRequestKey())) && !"number".equalsIgnoreCase(DatabaseTypeUtils.boolDataType(requestCondition.getRequestKey(), databaseType)) && ("date".equalsIgnoreCase(RequestKeyUtils.getTaskKeyType.get(requestCondition.getRequestKey())) || "date".equalsIgnoreCase(RequestKeyUtils.getProcKeyType.get(requestCondition.getRequestKey())) || "number".equalsIgnoreCase(DatabaseTypeUtils.boolDataType(requestCondition.getRequestKey(), databaseType)))) {
            try {
                if (DatabaseTypeUtils.QUERY_DATE_SET.contains(requestCondition.getRequestKey())) {
                    requestCondition.setRequestKey(DatabaseTypeUtils.QUERY_DATE_MAP_COMMOM.get(requestCondition.getRequestKey()) + "InLong");
                } else {
                    requestCondition.setRequestKey(requestCondition.getRequestKey() + "InLong");
                }
                Date date = sdf.parse(requestCondition.getRequestValue().toString());
                requestCondition.setRequestValue(date.getTime());
            }
            catch (Exception e) {
                logger.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38 :{}", (Object)e.getMessage());
            }
        }
    }

    private static JSONObject spliceCommomJson(final RequestCondition requestCondition, String queryType) {
        JSONObject json = new JSONObject();
        if (requestCondition.getRequestValue() != null) {
            json.put(queryType, (Object)new JSONObject(){
                {
                    this.put(requestCondition.getRequestKey(), requestCondition.getRequestValue());
                }
            });
        }
        return json;
    }

    private static JSONObject spliceRanageJson(final RequestCondition requestCondition, final String rangeType) {
        JSONObject rangeJson = new JSONObject();
        if (requestCondition.getRequestValue() != null) {
            rangeJson.put("range", (Object)new JSONObject(){
                {
                    this.put(requestCondition.getRequestKey(), new JSONObject(){
                        {
                            this.put(rangeType, requestCondition.getRequestValue());
                        }
                    });
                }
            });
        }
        return rangeJson;
    }

    private static JSONObject spliceLikeJson(final RequestCondition requestCondition) {
        JSONObject likeJson = new JSONObject();
        if (requestCondition.getRequestValue() != null) {
            requestCondition.setRequestValue("*" + requestCondition.getRequestValue() + "*");
            likeJson.put("wildcard", (Object)new JSONObject(){
                {
                    this.put(requestCondition.getRequestKey(), requestCondition.getRequestValue());
                }
            });
        }
        return likeJson;
    }

    private static JSONObject spliceOrderJson(final RequestCondition requestCondition) {
        JSONObject orderJson = new JSONObject();
        if (requestCondition.getRequestValue() != null) {
            orderJson.put(requestCondition.getRequestKey(), (Object)new JSONObject(){
                {
                    this.put("order", requestCondition.getRequestValue());
                }
            });
        }
        return orderJson;
    }

    public static JSONObject spliceDefalutOrderJson(JSONObject whereJson, final String priorityKey, final String timeKey) {
        if (!whereJson.containsKey((Object)"sort")) {
            whereJson.put("sort", (Object)new JSONObject(new LinkedHashMap()){
                {
                    super(x0);
                    this.put(priorityKey, new JSONObject(){
                        {
                            this.put("order", "desc");
                        }
                    });
                    this.put(timeKey, new JSONObject(){
                        {
                            this.put("order", "desc");
                        }
                    });
                }
            });
        }
        return whereJson;
    }

    private static void spliceSpecialCommomJSON(RequestCondition requestCondition, JSONArray andJson, JSONArray notJson) {
        String type;
        if (!org.springframework.util.StringUtils.isEmpty((Object)requestCondition.getRequestKey()) && requestCondition.getRequestKey().equals(TaskQueryKey.TASK_STATUS.value()) && requestCondition.getRequestValue() != null && StringUtils.isNotBlank((CharSequence)(type = requestCondition.getRequestValue().toString()))) {
            if (type.equals(TaskStatusQueryEqEnum.NORMAL.getValue())) {
                andJson.add((Object)new JSONObject(){
                    {
                        this.put("term", new JSONObject(){
                            {
                                this.put("taskStatus", 1);
                            }
                        });
                    }
                });
                andJson.add((Object)new JSONObject(){
                    {
                        this.put("term", new JSONObject(){
                            {
                                this.put("procStartTimeInLong", 0);
                            }
                        });
                    }
                });
                notJson.add((Object)new JSONObject(){
                    {
                        this.put("exists", new JSONObject(){
                            {
                                this.put("field", "backStatus");
                            }
                        });
                    }
                });
            } else if (type.equals(TaskStatusQueryEqEnum.BACK.getValue())) {
                andJson.add((Object)new JSONObject(){
                    {
                        this.put("term", new JSONObject(){
                            {
                                this.put("backStatus", 1);
                            }
                        });
                    }
                });
            } else if (type.equals(TaskStatusQueryEqEnum.BACKED.getValue())) {
                andJson.add((Object)new JSONObject(){
                    {
                        this.put("term", new JSONObject(){
                            {
                                this.put("backStatus", 2);
                            }
                        });
                    }
                });
            } else if (type.equals(TaskStatusQueryEqEnum.HANG.getValue())) {
                andJson.add((Object)new JSONObject(){
                    {
                        this.put("term", new JSONObject(){
                            {
                                this.put("taskStatus", 2);
                            }
                        });
                    }
                });
            } else if (type.equals(TaskStatusQueryEqEnum.TIMEOUT.getValue())) {
                andJson.add((Object)new JSONObject(){
                    {
                        this.put("term", new JSONObject(){
                            {
                                this.put("taskTimeoutStatus", 1);
                            }
                        });
                    }
                });
            }
        }
    }
}

