/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.clients.manage;

import cn.gtmap.gtc.workflow.domain.manage.CategoryProcessDto;
import cn.gtmap.gtc.workflow.domain.manage.OpinionDto;
import cn.gtmap.gtc.workflow.domain.manage.RuIdentitylink;
import cn.gtmap.gtc.workflow.domain.manage.TaskData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${app.services.bpm-manage:bpm-manage}")
@RequestMapping(value={"manage/v1"})
public interface ProcessTaskClient {
    @GetMapping(value={"/process-tasks/{taskId}"})
    public TaskData getTaskById(@PathVariable(value="taskId") String var1);

    @GetMapping(value={"/process-tasks/user/{taskId}"})
    public TaskData getTaskByIdAuthUser(@PathVariable(value="taskId") String var1, @RequestParam(value="username") String var2);

    @GetMapping(value={"/process-tasks/process-ins/current"})
    public List<TaskData> processRunningTasks(@RequestParam(value="processInsId") String var1);

    @GetMapping(value={"/process-tasks/process-ins/last"})
    public List<TaskData> processLastTasks(@RequestParam(value="processInsId") String var1);

    @GetMapping(value={"/process-tasks/process-ins/all"})
    public List<TaskData> listProcessTask(@RequestParam(value="processInsId") String var1);

    @GetMapping(value={"/process-tasks/category-process"})
    public List<CategoryProcessDto> listCategoryProcess(@RequestParam(value="username") String var1);

    @GetMapping(value={"/process-tasks/all-category-process"})
    public List<CategoryProcessDto> listAllCategoryProcess();

    @GetMapping(value={"/process-tasks/category-process-collection"})
    public Map<String, Object> listCollentionCategoryProcess(@RequestParam(value="username") String var1, @RequestParam(value="processDefName", required=false) String var2, @RequestParam(value="collectionType") String var3);

    @GetMapping(value={"/process-tasks/{userId}/task-list-addition"})
    public HashMap<String, Object> taskCreateList(@PathVariable(value="userId") String var1);

    @GetMapping(value={"/process-tasks/claim/count"})
    public Integer claimTaskCount(@RequestParam(value="username") String var1);

    @GetMapping(value={"/process-tasks/todo/count"})
    public Integer todoTaskCount(@RequestParam(value="username") String var1);

    @GetMapping(value={"/process-tasks/complete/count"})
    public Integer completeTaskCount(@RequestParam(value="username") String var1, @RequestParam(value="startTime", required=false) Long var2, @RequestParam(value="endTime", required=false) Long var3);

    @GetMapping(value={"/process-tasks/time-out/count"})
    public Integer timeOutTaskCount(@RequestParam(value="username") String var1);

    @GetMapping(value={"/process-tasks/task-list-unclaimed"})
    public Page<TaskData> claimTaskList(@RequestParam(value="username", required=false) String var1, @RequestParam(value="category", required=false) String var2, @RequestParam(value="processInstanceName", required=false) String var3, Pageable var4);

    @GetMapping(value={"/process-tasks/task-list-undoned"})
    public Page<TaskData> todoTaskList(@RequestParam(value="userId", required=false) String var1, @RequestParam(value="category", required=false) String var2, @RequestParam(value="processInstanceName", required=false) String var3, Pageable var4);

    @GetMapping(value={"/process-tasks/task-list-finished"})
    public Page<TaskData> completeTaskList(@RequestParam(value="userId") String var1, @RequestParam(value="category") String var2, @RequestParam(value="processInstanceName") String var3, Pageable var4);

    @GetMapping(value={"/process-tasks/{taskId}/task-idm"})
    public List<RuIdentitylink> getIdentityByTaskId(@PathVariable(value="taskId") String var1) throws Exception;

    @GetMapping(value={"/process-tasks/{taskId}/cancel-claim"})
    public boolean cancelTaskClaimBack(@PathVariable(value="taskId") String var1);

    @Deprecated
    @GetMapping(value={"/process-tasks/{taskId}/fallback"})
    public String taskRecaption(@PathVariable(value="taskId") String var1);

    @GetMapping(value={"/processInstanceManage"})
    public Object createNativeProcessInstanceQuery();

    @PostMapping(value={"/task-variables/{taskId}"})
    public void addTaskVariables(@PathVariable(value="taskId") String var1, @RequestParam(value="isLocal") Integer var2, @RequestBody Map<String, Object> var3);

    @GetMapping(value={"/task-variables/{taskId}"})
    public Map<String, Object> getTaskVariables(@PathVariable(value="taskId") String var1, @RequestParam(value="isLocal") Integer var2);

    @GetMapping(value={"/opinion"})
    public OpinionDto queryProcessOpinion(@RequestParam(value="processInsId") String var1, @RequestParam(value="taskId", required=false) String var2, @RequestParam(value="type") String var3);

    @GetMapping(value={"/opinions"})
    public List<OpinionDto> queryProcessOpinions(@RequestParam(value="processInsId") String var1, @RequestParam(value="taskId", required=false) String var2, @RequestParam(value="types") String var3);
}

