package cn.gtmap.gtc.workflow.enums.task;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/2/20
 * @description
 */
public enum CommentType {

    /*
     *  转发审批意见
     * */
    FORWARD_BEFORE_OPINION("forward_before_opinion"),

    /*
    *  转发下个节点审批意见
    * */
    FORWARD_OPINION("forward_opinion"),
    /*
     *  退回审批意见
     * */
    BACK_OPINION("back_opinion"),

    /*
     *  退回到下个节点审批意见
     * */
    NEXT_BACK_OPINION("next_back_opinion"),

    /*
     *  挂起意见
     * */
    SUSPEND_OPINION("suspend_opinion"),

    /*
     *  解挂意见
     * */
    ACTIVITY_OPINION("activity_opinion");

    private final String value;

    CommentType(String v){
        value = v;
    }

    public String value() {
        return value;
    }


    public static CommentType enumValue(String type){
        for (CommentType t : CommentType.values()){
            if (t.value.equals(type)){
                return t;
            }
        }
        return null;
    }
}
