package cn.gtmap.gtc.workflow.enums.manage;

/**
 * 任务状态码
 *
 * @author Fjj
 * @date 2018/11/27
 */
public enum TaskStatus {

    RUNNING(1, "激活"),

    SUSPEND(2,"挂起"),

    LOCKED(3, "锁定"),

    END(4, "结束");

    private Integer value;

    private String remark;

    public Integer getValue() {
        return value;
    }

    public String getRemark() {
        return remark;
    }

    TaskStatus(int value, String remark) {
        this.value = value;
        this.remark = remark;
    }

    public static String getStatusName(Integer status){
        if (status == null) {
            return null;
        }
        switch (status){
            case 1:
                return "激活";
            case 2:
                return "挂起";
            case 3:
                return "锁定";
            case 4:
                return "结束";
        }
        return null;
    }

    public static String getStatusName(String status){

        if ("1".equals(status)) {
            return "激活";
        } else if ("2".equals(status)) {
            return "挂起";
        }else if ("3".equals(status)) {
            return "锁定";
        }else if ("4".equals(status)) {
            return "结束";
        }
        return null;
    }
}