package cn.gtmap.gtc.workflow.enums.manage;

import java.util.HashMap;
import java.util.Map;

public enum TaskQueryKey {

    /**
     * 任务ID
     */
    TASK_ID("taskId","任务ID"),

    /**
     * 任务受理人， 用户username, 查询待办已办时，必传
     */
    TASK_ASSIGIN("taskAssigin","任务受理人"),

    /**
     * 任务受理人中文名，
     * */
    TASK_ASSIGIN_NAME("taskAssiginName","任务受理人中文名"),

    /**
     * 任务节点id
     */
    TASK_KEY("taskKey","任务节点id"),

    /**
     * 任务状态： NORMAL("normal", "正常任务"),BACK("back", "退回任务"),  BACKED("backed", "被退回任务"), HANG("hang","被挂起任务"), TIMEOUT("timeout", "超期任务");
     */
    TASK_STATUS("taskStatus","任务状态"),

    /**
     * 任务类型相等
     */
    TASK_TYPE("taskType","任务类型"),

    /*
     *任务名称
     */
    TASK_NAME("taskName","任务名称"),


    /**
     * 流程实例ID
     */
    PROCESS_INSTANCE_ID("processInstanceId","流程实例ID"),


    /**
     * 流程实例名称
     */
    PROCESS_INSTANCE_NAME("processInstanceName","流程实例名称"),

    /**
     * 流程状态 匹配
     */
    PROC_STATUS("procStatus","流程状态"),


    /*
     * 流程超期状态
     * */
    PROC_TIMEOUT_STATUS("procTimeOutStatus","流程超期状态"),


    /**
     * 开始时间 (同于待办)
     */
    START_TIME_TODO("startTime_todo","开始时间 (用于待办)"),

    /**
     * 开始时间（用于已办）
     */
    START_TIME_COMPLTETE("startTime_complete","开始时间（用于已办"),

    /**
     * 任务结束时间
     */
    END_TIME("endTime","任务结束时间"),

    /**
     * 优先级
     */
    PRIORITY("priority","优先级"),

    /**
     * 流程实例启动人ID（对应用户中心）
     * <p>
     * 对用用户权限中心 username
     */
    START_USER_ID("startUserId","流程实例启动人ID"),


    /**
     * 流程实例启动人部门ID
     * <p>
     */
    START_USER_DEP_ID("startUserDepId","流程实例启动人部门ID"),

    /**
     * 流程实例启动人姓名
     */
    START_USER_NAME("startUserName","流程实例启动人姓名"),
    /**
     * 流程定义ID
     */
    PROCESS_DEF_ID("processDefId","流程定义ID"),

    /**
     * 流程定义唯一标识
     */
    PROCESS_KEY("processKey","流程定义唯一标识"),

    /**
     * 流程定义名称
     */
    PROCESS_DEF_NAME("processDefName","流程定义名称"),

    /**
     * 委托状态
     */
    DELEGATION("delegation","委托状态"),

    /**
     * 流程业务类别
     */
    CATEGORY("category","流程业务类别"),

    /**
     * 任务到期天数
     */
    TASK_DUE_DAYS("taskDueDays","任务到期天数"),

    /**
     * 任务到期时数
     */
    TASK_DUE_HOURS("taskDueHours","任务到期时数"),

    /**
     * 任务超期天数
     */
    TASK_TIMEOUT_DAYS("taskTimeoutDays","任务超期天数"),

    /**
     * 任务超期时数
     */
    TASK_TIMEOUT_HOURS("taskTimeoutHours","任务超期时数"),

    /**
     * 项目ID
     */
    PROJECTID("projectId","项目ID"),

    /**
     * 项目名称
     */
    PROJECT_NAME("projectName","项目名称"),

    /**
     * 组织ID相等
     */
    TASK_ORG_ID("taskOrg","组织ID"),


    /**
     * 项目超时天数
     */
    PROC_TIMEOUT_DAY("procTimeout","项目超时天数"),

    /**
     * 角色列表查询
     */
    TASK_ROLE_ID("taskAssRoleId","角色列表查询");


    private final String value;

    private final String remark;

    TaskQueryKey(String value,String remark) {
        this.value = value;
        this.remark = remark;
    }

    public String value() {
        return value;
    }



}
