package cn.gtmap.gtc.workflow.clients.manage;

import cn.gtmap.gtc.sso.domain.dto.UserDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @author <a href="mailto:yuxinwang@gtmap.cn">yxw</a>
 * @version 1.0, 2018/9/11
 * @description 流程定义活动节点人员
 */

@FeignClient("${app.services.bpm-manage:bpm-manage}")
@RequestMapping("manage/v1")
public interface TaskUserClient {

    /**
     * 根据任务ID获取下个节点的角色人员数组
     *
     * @throws Throwable
     */
    @RequestMapping(value = "/task-users/{taskId}/next-node-users", method = RequestMethod.GET)
    public List<UserDto> getNextNodeUsers(@PathVariable("taskId") String taskId);

    /**
     * 根据任务ID获取当前节点的角色或组织人员数组
     *
     * @throws Throwable
     */
    @RequestMapping(value = "/task-users/{taskId}/current-node-users", method = RequestMethod.GET)
    List<UserDto> getCurrentNodeUsers(@PathVariable("taskId") String taskId);

    /**
     * 根据角色id获取所有人员
     * @param allRoleAry
     * @return
     */
    @RequestMapping(value = "/task-users/users", method = RequestMethod.POST)
    List<UserDto> getAllUsersByRoleId(@RequestBody List<String> allRoleAry);

    /**
     * 查询所有用户
     * @param pageable
     * @return
     */
    @RequestMapping(value = "/users/all-list", method = RequestMethod.GET)
    Page<UserDto> getAllUsersList(Pageable pageable);
}
