package cn.gtmap.gtc.workflow.clients.manage;

import cn.gtmap.gtc.sso.domain.dto.RoleDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.HashMap;
import java.util.List;

/**
 * @author <a href="mailto:yuxinwang@gtmap.cn">yxw</a>
 * @version 1.0, 2018/11/16
 * @description 流程定义活动节点角色
 */

@FeignClient("${app.services.bpm-manage:bpm-manage}")
@RequestMapping("manage/v1")
public interface TaskRoleClient {

    /**
     * 根据任务ID获取下个节点的角色数组
     * @param taskId
     * @return
     */
    @RequestMapping(value = "/task-roles/{taskId}/next-node-roles", method = RequestMethod.GET)
    public List<RoleDto> getNextNodeRoles(@PathVariable("taskId") String taskId);

    /**
     * 根据登录人id获取所属角色
     * @param userId
     * @return
     */
    @RequestMapping(value = "/task-roles/{userId}/login-roles", method = RequestMethod.GET)
    public List getLoginRoles(@PathVariable("userId") String userId);

    /**
     * 根据任务节点key获取所属角色
     * @param taskDefKey
     * @return
     * @throws Throwable
     */
    @RequestMapping(value = "/node-roles/{taskDefKey}/all-roles", method = RequestMethod.GET)
    public List<RoleDto> getAllRolesByTaskDefKey(@PathVariable("taskDefKey") String taskDefKey);

    /**
     * 根据角色id数组获取所属角色
     * @param roleIdAry
     * @return
     * @throws Throwable
     */
    @RequestMapping(value = "/node-roles/roleId-roles", method = RequestMethod.POST)
    public List<RoleDto> getAllRolesByroleId(@RequestBody List<String> roleIdAry);

    /**
     * 获取下个任务节点的角色和处理人map
     * @param taskId
     * @return
     */
    @RequestMapping(value = "/node-roles/{taskId}/task-roles-users", method = RequestMethod.GET)
    HashMap<String, Object> getRoleUsers(@PathVariable("taskId") String taskId);

}
