package cn.gtmap.gtc.workflow.clients.manage;

import cn.gtmap.gtc.workflow.domain.common.RequestCondition;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @Classname cn.gtmap.gtc.workflow.clients.manage
 * @Description 流程任务的查询接口（带业务扩展属性的）
 * @Date 2020/4/7 14:23
 * @Created by zhouk
 */
@FeignClient("${app.services.bpm-manage:bpm-manage}")
@RequestMapping("manage/v1")
public interface ProcessTaskCustomExtendClient {

    /**
     * 带业务的扩展属性待办任务列表
     *
     * @return
     */
    @RequestMapping(value = "/process-task-custom-extend/task-list-undoned", method = RequestMethod.POST)
    Page<Map<String,Object>> todoTaskExtendList(@RequestBody List<RequestCondition> requestConditions,
                                                @RequestParam("pageSize") Integer pageSize,
                                                @RequestParam("pageNumber") Integer pageNumber);


    /**
     * 根据权限和请求条件获取带业务的扩展属性的待办任务列表
     * @param requestConditions
     * @param pageSize
     * @param pageNumber
     * @return
     */
    @RequestMapping(value = "/process-task-custom-extend/task-list-finished", method = RequestMethod.POST)
    Page<Map<String,Object>> completeTaskExtendList(@RequestBody List<RequestCondition> requestConditions,
                                                    @RequestParam("pageSize") Integer pageSize,
                                                    @RequestParam("pageNumber") Integer pageNumber);


    /**
     * 认领列表
     * @param
     * @param username
     * @return 认领列表
     */
    @RequestMapping(value = "/process-task-custom-extend/task-list-claim", method = RequestMethod.POST)
    Page<Map<String,Object>> claimTaskExtendList(@RequestBody(required = false) List<RequestCondition> requestConditions,
                                                 @RequestParam("username") String username,
                                                 @RequestParam("pageSize") Integer pageSize,
                                                 @RequestParam("pageNumber") Integer pageNumber);

    /**
     *  查看全部项目列表
     * @param requestConditions
     * @param queryType 默认 1 是按照角色查询
     * @param pageSize
     * @param pageNumber
     * @return
     */
    @RequestMapping(value = "/process-task-custom-extend/project-all", method = RequestMethod.POST)
    Page<Map<String,Object>> queryProcessInsWithProject(@RequestBody(required = false) List<RequestCondition> requestConditions,
                                                        @RequestParam(value = "queryType",required = false) Integer queryType,
                                                        @RequestParam("pageSize") Integer pageSize,
                                                        @RequestParam("pageNumber") Integer pageNumber);


    /**
     * 查看个人项目列表
     * @param requestConditions
     * @param pageSize
     * @param pageNumber
     * @return
     */
    @RequestMapping(value = "/process-task-custom-extend/project-personal", method = RequestMethod.POST)
    Page<Map<String,Object>> queryPersonalProcessIns(@RequestBody List<RequestCondition> requestConditions,
                                                     @RequestParam("pageSize") Integer pageSize,
                                                     @RequestParam("pageNumber") Integer pageNumber);


    /**
     *  查询办结节点项目列表
     * @param requestConditions
     * @param pageSize
     * @param pageNumber
     * @return
     */
    @RequestMapping(value = "/process-task-custom-extend/project-finish", method = RequestMethod.POST)
    Page<Map<String,Object>> queryTaskFinishProcessIns(@RequestBody(required = false) List<RequestCondition> requestConditions,
                                                       @RequestParam("pageSize") Integer pageSize,
                                                       @RequestParam("pageNumber") Integer pageNumber);

    /**
     *  根据请求条件获取交接单列表
     * @param requestConditions
     * @param pageSize
     * @param pageNumber
     * @return
     */
    @RequestMapping(value = "/process-task-custom-extend/task-receipt", method = RequestMethod.POST)
    Page<Map<String,Object>> allReceiptExtend(@RequestBody(required = false) List<RequestCondition> requestConditions,
                                              @RequestParam(value = "pageSize", required = false) Integer pageSize,
                                              @RequestParam(value = "pageNumber", required = false) Integer pageNumber);
}
