/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.helper;

import cn.gtmap.gtc.workflow.domain.define.WorkDay;
import cn.gtmap.gtc.workflow.helper.AbstractWorkdayHelper;
import cn.gtmap.gtc.workflow.utils.DateUtils;
import java.text.ParseException;
import java.util.Calendar;
import java.util.List;

public class SimpleWorkdayHelper
extends AbstractWorkdayHelper {
    private static final String LAST_TIME = "23:59:59";

    public SimpleWorkdayHelper(List<WorkDay> list) {
        this.init(list);
    }

    @Override
    public Calendar addDateByWorkDay(Calendar calendar, int day) throws ParseException {
        AbstractWorkdayHelper.WorkDayTimeType workDayTimeType = this.checkWorkTimeType(calendar);
        Calendar dueCalendar = null;
        if (workDayTimeType == AbstractWorkdayHelper.WorkDayTimeType.NOT_WORKDAY || workDayTimeType == AbstractWorkdayHelper.WorkDayTimeType.BEFORE_MORNING_STRAT || workDayTimeType == AbstractWorkdayHelper.WorkDayTimeType.AFTER_AFTERNOON_END) {
            Calendar realStartTime = this.getNearWorkTime(calendar, workDayTimeType);
            String realStartDateStr = this.dateFormat.format(realStartTime.getTime());
            int indexInWorkDay = (Integer)this.indexMap.get(realStartDateStr) + (day - 1);
            WorkDay workDay = (WorkDay)this.workDayList.get(indexInWorkDay);
            dueCalendar = DateUtils.toCalendar(workDay.getWorkDay() + " " + LAST_TIME, DateUtils.DateFormatType.DATETIME);
        } else {
            String dateStr = this.dateFormat.format(calendar.getTime());
            int indexInWorkDay = (Integer)this.indexMap.get(dateStr);
            int dueIndexInWorkDay = indexInWorkDay + day;
            WorkDay dueWorkDay = (WorkDay)this.workDayList.get(dueIndexInWorkDay);
            dueCalendar = DateUtils.toCalendar(dueWorkDay.getWorkDay() + " " + LAST_TIME, DateUtils.DateFormatType.DATETIME);
        }
        return dueCalendar;
    }
}

