/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.helper;

import cn.gtmap.gtc.workflow.domain.define.WorkDay;
import cn.gtmap.gtc.workflow.utils.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorkdayHelper {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractWorkdayHelper.class);
    protected List<WorkDay> workDayList = new LinkedList<WorkDay>();
    protected List<WorkMinutes> workMinutesList = new LinkedList<WorkMinutes>();
    protected Map<String, Integer> indexMap = new HashMap<String, Integer>();
    protected List<String> allDaysList = new LinkedList<String>();
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    protected SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected static final String A_BLANK = " ";

    public void init(List<WorkDay> dates) {
        this.workDayList.clear();
        this.workMinutesList.clear();
        this.indexMap.clear();
        this.allDaysList.clear();
        int index = 0;
        for (WorkDay workDay : dates) {
            if (workDay.getDayType() == 0) {
                this.workDayList.add(workDay);
                this.workMinutesList.add(new WorkMinutes(DateUtils.getTimeDifferenceInMinutesByTime(workDay.getMorningTimeStart(), workDay.getMorningTimeEnd()), DateUtils.getTimeDifferenceInMinutesByTime(workDay.getAfternoonTimeStart(), workDay.getAfternoonTimeEnd())));
                this.indexMap.put(workDay.getWorkDay(), index++);
            }
            this.allDaysList.add(workDay.getWorkDay());
        }
    }

    public WorkDayTimeType checkWorkTimeType(Calendar calendar) {
        WorkDay workDay;
        if (!this.checkWorkDay(calendar)) {
            return WorkDayTimeType.NOT_WORKDAY;
        }
        Date date = calendar.getTime();
        String timeStr = this.timeFormat.format(date);
        if (timeStr.compareTo((workDay = this.workDayList.get(this.indexMap.get(this.dateFormat.format(date)))).getMorningTimeStart()) < 0) {
            return WorkDayTimeType.BEFORE_MORNING_STRAT;
        }
        if (timeStr.compareTo(workDay.getMorningTimeStart()) >= 0 && timeStr.compareTo(workDay.getMorningTimeEnd()) < 0) {
            return WorkDayTimeType.MORNING_WORKTIME;
        }
        if (timeStr.compareTo(workDay.getMorningTimeEnd()) >= 0 && timeStr.compareTo(workDay.getAfternoonTimeStart()) < 0) {
            return WorkDayTimeType.LUNCH_BREAK;
        }
        if (timeStr.compareTo(workDay.getAfternoonTimeStart()) >= 0 && timeStr.compareTo(workDay.getAfternoonTimeEnd()) < 0) {
            return WorkDayTimeType.AFTERNOON_WORKTIME;
        }
        return WorkDayTimeType.AFTER_AFTERNOON_END;
    }

    public boolean checkWorkDay(Calendar calendar) {
        return this.indexMap.containsKey(this.dateFormat.format(calendar.getTime()));
    }

    public boolean checkWorkDay(String str) {
        return this.indexMap.containsKey(str);
    }

    protected WorkDay getWorkDay(Calendar calendar) {
        Integer index = this.indexMap.get(this.dateFormat.format(calendar.getTime()));
        return this.isNull(index) ? null : this.workDayList.get(index);
    }

    protected Calendar getNearWorkTime(Calendar calendar, WorkDayTimeType workDayTimeType) throws ParseException {
        if (workDayTimeType == null) {
            workDayTimeType = this.checkWorkTimeType(calendar);
        }
        Date date = calendar.getTime();
        String dateStr = this.dateFormat.format(date);
        Calendar result = null;
        String temp = "";
        switch (workDayTimeType) {
            case NOT_WORKDAY: {
                WorkDay workDay = this.getNextWorkDay(dateStr);
                temp = workDay.getWorkDay() + A_BLANK + workDay.getMorningTimeStart();
                result = DateUtils.toCalendar(this.dateTimeFormat.parse(temp));
                break;
            }
            case BEFORE_MORNING_STRAT: {
                WorkDay workDay = this.workDayList.get(this.indexMap.get(dateStr));
                temp = dateStr + A_BLANK + workDay.getMorningTimeStart();
                result = DateUtils.toCalendar(this.dateTimeFormat.parse(temp));
                break;
            }
            case MORNING_WORKTIME: {
                result = calendar;
                break;
            }
            case LUNCH_BREAK: {
                WorkDay workDay = this.workDayList.get(this.indexMap.get(dateStr));
                temp = dateStr + A_BLANK + workDay.getAfternoonTimeStart();
                result = DateUtils.toCalendar(this.dateTimeFormat.parse(temp));
                break;
            }
            case AFTERNOON_WORKTIME: {
                result = calendar;
                break;
            }
            case AFTER_AFTERNOON_END: {
                temp = this.getNextWorkDay(dateStr).getWorkDay() + A_BLANK + this.getNextWorkDay(dateStr).getMorningTimeStart();
                result = DateUtils.toCalendar(this.dateTimeFormat.parse(temp));
                break;
            }
        }
        return result;
    }

    protected WorkDay getNextWorkDay(String date) {
        for (WorkDay workDay : this.workDayList) {
            if (workDay.getWorkDay().compareTo(date) <= 0) continue;
            return workDay;
        }
        return null;
    }

    public abstract Calendar addDateByWorkDay(Calendar var1, int var2) throws ParseException;

    public Calendar addMinuteByWorkDay(Calendar calendar, int minute) throws ParseException {
        int minutes;
        WorkMinutes workMinutes;
        int totalMinutes = minute;
        Calendar start = this.getNearWorkTime(calendar, null);
        WorkDayTimeType workDayTimeType = this.checkWorkTimeType(start);
        String dateStr = this.dateFormat.format(start.getTime());
        WorkDay workDay = this.workDayList.get(this.indexMap.get(dateStr));
        for (minutes = this.getRemainningMinutes(start, workDayTimeType); totalMinutes > minutes; minutes += workMinutes.getMorningMinutes() + workMinutes.getAfternoonMinutes()) {
            workDay = this.getNextWorkDay(dateStr);
            workMinutes = this.workMinutesList.get(this.indexMap.get(workDay.getWorkDay()));
            dateStr = workDay.getWorkDay();
        }
        int temp = minutes - totalMinutes;
        WorkMinutes workMinutes2 = this.workMinutesList.get(this.indexMap.get(dateStr));
        if (temp > workMinutes2.getAfternoonMinutes()) {
            return DateUtils.addMinutes(DateUtils.toCalendar(this.dateTimeFormat.parse(dateStr + A_BLANK + workDay.getMorningTimeEnd())), -(temp - workMinutes2.getAfternoonMinutes()));
        }
        return DateUtils.addMinutes(DateUtils.toCalendar(this.dateTimeFormat.parse(dateStr + A_BLANK + workDay.getAfternoonTimeEnd())), -temp);
    }

    public Calendar addHourByWorkDay(Calendar calendar, int hour) throws ParseException {
        int totalMinutes = hour * 60;
        return this.addMinuteByWorkDay(calendar, totalMinutes);
    }

    private int getRemainningMinutes(Calendar start, WorkDayTimeType workDayTimeType) {
        int result = 0;
        WorkDay workDay = this.getWorkDay(start);
        String timeStr = this.timeFormat.format(start.getTime());
        switch (workDayTimeType) {
            case BEFORE_MORNING_STRAT: {
                result = (int)(60.0f * workDay.getDuraction().floatValue());
                break;
            }
            case MORNING_WORKTIME: {
                result = (int)((DateUtils.toTime(workDay.getAfternoonTimeEnd()).getTime() - DateUtils.toTime(workDay.getAfternoonTimeStart()).getTime()) / 60000L);
                result += (int)((DateUtils.toTime(workDay.getMorningTimeEnd()).getTime() - DateUtils.toTime(timeStr).getTime()) / 60000L);
                break;
            }
            case LUNCH_BREAK: {
                result = (int)((DateUtils.toTime(workDay.getAfternoonTimeEnd()).getTime() - DateUtils.toTime(workDay.getAfternoonTimeStart()).getTime()) / 60000L);
                break;
            }
            case AFTERNOON_WORKTIME: {
                result = (int)((DateUtils.toTime(workDay.getAfternoonTimeEnd()).getTime() - DateUtils.toTime(timeStr).getTime()) / 60000L);
                break;
            }
            case AFTER_AFTERNOON_END: {
                result = 0;
                break;
            }
            default: {
                result = -1;
            }
        }
        return result;
    }

    public int getBetweenDays(Calendar start, Calendar now) {
        String endDayStr;
        String startDayStr;
        boolean isTimeout;
        int result = 0;
        boolean bl = isTimeout = now.compareTo(start) > 0;
        if (!isTimeout) {
            Calendar temp = start;
            start = now;
            now = temp;
        }
        if ((startDayStr = this.dateFormat.format(start.getTime())).equals(endDayStr = this.dateFormat.format(now.getTime()))) {
            return result;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start.getTime());
        calendar.add(5, 1);
        String tempDayStr = this.dateFormat.format(calendar.getTime());
        while (startDayStr.compareTo(tempDayStr) < 0) {
            if (this.checkWorkDay(tempDayStr)) {
                ++result;
            }
            if (tempDayStr.equals(endDayStr)) break;
            startDayStr = tempDayStr;
            calendar.add(5, 1);
            tempDayStr = this.dateFormat.format(calendar.getTime());
        }
        if (isTimeout) {
            return result;
        }
        return -result;
    }

    private int getBetweenOnDayMins(Calendar start) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start.getTime());
        calendar.set(11, 23);
        calendar.set(12, 59);
        return this.getTimeOutMinutesInSameDay(start, calendar);
    }

    public int getBetweenHours(Calendar start, Calendar now) throws ParseException {
        boolean isTimeout;
        int result = 0;
        boolean bl = isTimeout = now.compareTo(start) > 0;
        if (!isTimeout) {
            Calendar temp = start;
            start = now;
            now = temp;
        }
        String startDayStr = this.dateFormat.format(start.getTime());
        String endDayStr = this.dateFormat.format(now.getTime());
        if (this.checkWorkDay(startDayStr) && startDayStr.equals(endDayStr)) {
            result += this.getTimeOutMinutesInSameDay(start, now);
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(start.getTime());
            while (!this.checkWorkDay(startDayStr)) {
                calendar.add(5, 1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                if (calendar.compareTo(now) > 0) {
                    return 0;
                }
                startDayStr = this.dateFormat.format(calendar.getTime());
            }
            while (!startDayStr.equals(endDayStr)) {
                if (this.checkWorkDay(startDayStr)) {
                    result += this.getBetweenOnDayMins(calendar);
                }
                calendar.add(5, 1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                startDayStr = this.dateFormat.format(calendar.getTime());
            }
            if (this.checkWorkDay(startDayStr)) {
                result += this.getTimeOutMinutesInSameDay(calendar, now);
            }
        }
        if (result == 0) {
            return result;
        }
        result = (int)Math.ceil((float)result / 60.0f);
        if (isTimeout) {
            return result;
        }
        return -result;
    }

    public int getBetweenMinis(Calendar start, Calendar now) throws ParseException {
        boolean isTimeout;
        int result = 0;
        boolean bl = isTimeout = now.compareTo(start) > 0;
        if (!isTimeout) {
            Calendar temp = start;
            start = now;
            now = temp;
        }
        String startDayStr = this.dateFormat.format(start.getTime());
        String endDayStr = this.dateFormat.format(now.getTime());
        if (this.checkWorkDay(startDayStr) && startDayStr.equals(endDayStr)) {
            result += this.getTimeOutMinutesInSameDay(start, now);
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(start.getTime());
            while (!this.checkWorkDay(startDayStr)) {
                calendar.add(5, 1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                if (calendar.compareTo(now) > 0) {
                    return 0;
                }
                startDayStr = this.dateFormat.format(calendar.getTime());
            }
            while (!startDayStr.equals(endDayStr)) {
                if (this.checkWorkDay(startDayStr)) {
                    result += this.getBetweenOnDayMins(calendar);
                }
                calendar.add(5, 1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                startDayStr = this.dateFormat.format(calendar.getTime());
            }
            if (this.checkWorkDay(startDayStr)) {
                result += this.getTimeOutMinutesInSameDay(calendar, now);
            }
        }
        if (result <= 0) {
            result = 0 - result;
        }
        return result;
    }

    public int getTimeOutDays(Calendar due, Calendar now) {
        String endDayStr;
        String startDayStr;
        boolean isTimeout;
        boolean bl = isTimeout = now.compareTo(due) > 0;
        if (!isTimeout) {
            Calendar temp = due;
            due = now;
            now = temp;
        }
        if ((startDayStr = this.dateFormat.format(due.getTime())).equals(endDayStr = this.dateFormat.format(now.getTime()))) {
            return isTimeout ? 1 : 0;
        }
        int result = 0;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(due.getTime());
        while (startDayStr.compareTo(endDayStr) < 0) {
            if (this.checkWorkDay(startDayStr)) {
                ++result;
            }
            calendar.add(5, 1);
            startDayStr = this.dateFormat.format(calendar.getTime());
        }
        if (isTimeout) {
            return result;
        }
        return result == 0 ? -1 : -result;
    }

    private String getNextDayStr(String date, DateUtils.DateFormatType dateFormatType) throws ParseException {
        Calendar calendar = DateUtils.toCalendar(date, dateFormatType);
        calendar.add(5, 1);
        return this.dateFormat.format(calendar.getTime());
    }

    public int getTimeOutMinutesInSameDay(Calendar due, Calendar now) throws ParseException {
        Calendar start = due;
        Calendar end = now;
        if (due.compareTo(now) > 0) {
            end = due;
            start = now;
        }
        Date startDate = start.getTime();
        Date endDate = end.getTime();
        String dayStr = this.dateFormat.format(endDate);
        int index = this.indexMap.get(dayStr);
        WorkDay workDay = this.workDayList.get(index);
        Date morningStart = this.dateTimeFormat.parse(dayStr + A_BLANK + workDay.getMorningTimeStart());
        Date morningEnd = this.dateTimeFormat.parse(dayStr + A_BLANK + workDay.getMorningTimeEnd());
        Date afternoonStart = this.dateTimeFormat.parse(dayStr + A_BLANK + workDay.getAfternoonTimeStart());
        Date afternoonEnd = this.dateTimeFormat.parse(dayStr + A_BLANK + workDay.getAfternoonTimeEnd());
        if (startDate.compareTo(morningStart) <= 0) {
            startDate = morningStart;
        } else if (startDate.compareTo(morningEnd) >= 0 && startDate.compareTo(afternoonStart) <= 0) {
            startDate = afternoonStart;
        } else if (startDate.compareTo(afternoonEnd) > 0) {
            startDate = afternoonEnd;
        }
        if (endDate.compareTo(morningStart) <= 0) {
            endDate = morningStart;
        } else if (endDate.compareTo(morningEnd) >= 0 && endDate.compareTo(afternoonStart) <= 0) {
            endDate = afternoonStart;
        } else if (endDate.compareTo(afternoonEnd) > 0) {
            endDate = afternoonEnd;
        }
        int result = 0;
        result = DateUtils.getTimeDifferenceInMinutesByDate(startDate, endDate);
        if (startDate.compareTo(morningEnd) <= 0 && endDate.compareTo(afternoonStart) >= 0) {
            result -= DateUtils.getTimeDifferenceInMinutesByDate(morningEnd, afternoonStart);
        }
        if (result <= 0) {
            return 0;
        }
        return result;
    }

    protected boolean isNull(Object object) {
        return object == null;
    }

    protected static enum WorkDayTimeType {
        NOT_WORKDAY(-1, "\u975e\u5de5\u4f5c\u65e5"),
        BEFORE_MORNING_STRAT(0, "\u65e9\u6668\u5de5\u4f5c\u65f6\u95f4\u4ee5\u524d"),
        MORNING_WORKTIME(1, "\u65e9\u6668\u5de5\u4f5c\u65f6\u95f4\u5185"),
        LUNCH_BREAK(2, "\u5348\u4f11\u65f6\u95f4"),
        AFTERNOON_WORKTIME(3, "\u4e0b\u5348\u5de5\u4f5c\u65f6\u95f4\u5185"),
        AFTER_AFTERNOON_END(4, "\u4e0b\u5348\u4e0b\u73ed\u4ee5\u540e");

        private int value;
        private String remark;

        private WorkDayTimeType(int value, String remark) {
            this.value = value;
            this.remark = remark;
        }
    }

    protected class WorkMinutes {
        private int morningMinutes;
        private int afternoonMinutes;

        public WorkMinutes() {
        }

        public WorkMinutes(int morningMinutes, int afternoonMinutes) {
            this.morningMinutes = morningMinutes;
            this.afternoonMinutes = afternoonMinutes;
        }

        public int getMorningMinutes() {
            return this.morningMinutes;
        }

        public void setMorningMinutes(int morningMinutes) {
            this.morningMinutes = morningMinutes;
        }

        public int getAfternoonMinutes() {
            return this.afternoonMinutes;
        }

        public void setAfternoonMinutes(int afternoonMinutes) {
            this.afternoonMinutes = afternoonMinutes;
        }
    }

    protected class DayIndexData {
        private String date;
        private int index;
        private int type;

        public DayIndexData(String date, int index, int type) {
            this.date = date;
            this.index = index;
            this.type = type;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }
    }
}

