package cn.gtmap.gtc.workflow.enums.variable;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/1/24
 * @description 转发类型
 */
public enum CompleteMode {

    /*
     * 指定人员
     * */
    APPOINT(0, "appoint","指派"),

    UNCLAIMED(1, "unclaim","未认领"),
    /*
     * 认领
     * */
    CLAIM(2, "claim","认领");

    private int status;

    private String value;

    private String remark;

    CompleteMode(int status, String v, String remark){
        this.status = status;
        this.value = v;
        this.remark = remark;
    }

    public int getStatus() {
        return status;
    }

    public String getRemark() {
        return remark;
    }

    public String value() {
        return value;
    }

    public static CompleteMode enumVale(String value){
        if ("appoint".equals(value)) {
            return APPOINT;
        }

        if ("claim".equals(value)) {
            return CLAIM;
        }

        return APPOINT;
    }

    public static String getClaimStatusName(Integer value){
        if (value == null) {
            return "指派";
        }

        switch (value){
            case 0:
                return "指派";
            case 1:
                return "未认领";
            case 2:
                return "认领";
        }

        return "指派";
    }
}
