package cn.gtmap.gtc.workflow.clients.manage;

import cn.gtmap.gtc.workflow.domain.common.RequestCondition;
import cn.gtmap.gtc.workflow.domain.manage.ProcessInsWithProjectDto;
import cn.gtmap.gtc.workflow.domain.manage.TaskExtendDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient("${app.services.bpm-manage:bpm-manage}")
@RequestMapping("manage/v1")
public interface ProcessTaskRestClient {
    /**
     * 带业务的扩展属性待办任务列表
     * @param requestConditions
     * @param pageSize
     * @param pageNumber
     * @return
     */
    @PostMapping("/process-tasks/task-list-undoned/processIns-extend")
    Page<TaskExtendDto> todoTaskExtendList(@RequestBody List<RequestCondition> requestConditions,
                                                  @RequestParam("pageSize") Integer pageSize,
                                                  @RequestParam("pageNumber") Integer pageNumber);

    /**
     * 带业务的扩展属性已办任务列表
     */
    @PostMapping("/process-tasks/task-list-finished/processIns-extend")
    Page<TaskExtendDto> completeTaskExtendList(@RequestBody List<RequestCondition> requestConditions,
                                                      @RequestParam("pageSize") Integer pageSize,
                                                      @RequestParam("pageNumber") Integer pageNumber);


    /**
     * 查询所有已办任务列表
     */
    @RequestMapping(value = "/process-tasks/all/finished", method = RequestMethod.POST)
    Page<TaskExtendDto> allFinishTaskExtendList(@RequestBody List<RequestCondition> requestConditions,
                                                       @RequestParam("pageSize") Integer pageSize,
                                                       @RequestParam("pageNumber") Integer pageNumber);

    /**
     * 带业务的扩展属性认领任务列表
     * @param requestConditions
     * @param pageSize
     * @param pageNumber
     * @return
     */
    @PostMapping("/process-tasks/task-list-claim/processIns-extend")
    Page<TaskExtendDto> claimTaskExtendList( @RequestBody(required = false) List<RequestCondition> requestConditions,
                                                    @RequestParam("username") String username,
                                                    @RequestParam("pageSize") Integer pageSize,
                                                    @RequestParam("pageNumber") Integer pageNumber);

    /**
     * 带扩展属性的流程实例列表
     * @param requestConditions
     * @return
     */
    @PostMapping(value = "/process-tasks/processIns-extend")
    Page<ProcessInsWithProjectDto> queryProcessInsWithProject(@RequestBody List<RequestCondition> requestConditions,
                                                              @RequestParam("pageSize") Integer pageSize,
                                                              @RequestParam("pageNumber") Integer pageNumber);

    /**
     * 查看个人项目列表
     * @param requestConditions
     * @return
     */
    @RequestMapping(value = "/process-tasks/personal/processIns-extend", method = RequestMethod.POST)
    Page<ProcessInsWithProjectDto> queryPersonalProcessIns(@RequestBody(required = false) List<RequestCondition> requestConditions,
                                                           @RequestParam("pageSize") Integer pageSize,
                                                           @RequestParam("pageNumber") Integer pageNumber);

    /**
     * 查询办结节点项目列表
     * @param requestConditions
     * @return
     */
    @PostMapping(value = "/process-tasks/finish/task-processIns")
    Page<ProcessInsWithProjectDto> queryTaskFinishProcessIns(@RequestBody(required = false) List<RequestCondition> requestConditions,
                                                             @RequestParam("pageSize") Integer pageSize,
                                                             @RequestParam("pageNumber") Integer pageNumber);

    /**
     * 根据请求条件获取任务交接单列表  pageSize, pageNumber 全部为空则返回所有数据
     * @param requestConditions 请求条件
     * @param pageSize
     * @param pageNumber
     * @return
     */
    @PostMapping(value = "/process-tasks/task-list/receipt-extend")
    Page<TaskExtendDto> allReceiptExtend(@RequestBody(required = false) List<RequestCondition> requestConditions,
                                         @RequestParam(value="pageSize",required = false) Integer pageSize,
                                         @RequestParam(value="pageNumber",required = false) Integer pageNumber);
}
