package cn.gtmap.gtc.workflow.clients.manage;


import cn.gtmap.gtc.workflow.domain.manage.ProcessInsExtendDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@FeignClient("${app.services.bpm-manage:bpm-manage}")
@RequestMapping("manage/v1")
public interface ProcessInsExtendClient {

    /**
     * 根据流程实例ID获取业务扩展数据
     * @param processInsId
     * @return
     */
    @GetMapping("/processIns-extend/{processInsId}")
    List<ProcessInsExtendDto> getProcessInsExtendList(@PathVariable("processInsId") String processInsId);

    /**
     * 新增/更新业务扩展属性
     * @param processInsExtendDto
     */
    @PostMapping("/processIns-extend")
    boolean saveProcessInsExtend(@RequestBody ProcessInsExtendDto processInsExtendDto);

    /**
     * 更新部分业务扩展属性
     * @param processInsExtendDto
     */
    @PutMapping("/processIns-extend")
    boolean savePartProcessInsExtend(@RequestBody ProcessInsExtendDto processInsExtendDto);

    /**
     * 批量新增/更新业务扩展属性
     * @param processInsExtendDtos
     */
    @PostMapping("/batch/processIns-extend")
    boolean saveProcessInsExtends(@RequestBody List<ProcessInsExtendDto> processInsExtendDtos);

    /**
     * 删除业务扩展属性
     * @param processInsId
     */
    @DeleteMapping("/processIns-extend/{processInsId}")
    boolean deleteProcessInsExtend(@PathVariable("processInsId") String processInsId);
}
