package cn.gtmap.gtc.workflow.utils;


import cn.gtmap.gtc.workflow.domain.common.MultipartDto;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/10/31
 * @description
 */
public class ConventMultipartFile  implements MultipartFile {

    private MultipartDto dto;

    private String uploader;  //上传人的名称 username

    public ConventMultipartFile(MultipartDto dto) {
        this.dto = dto;
    }

    @Override
    public String getName() {
        return dto.getName();
    }

    @Override
    public String getOriginalFilename() {
        return dto.getOriginalFilename();
    }

    @Override
    public String getContentType() {
        return dto.getContentType();
    }

    @Override
    public boolean isEmpty() {
        if (dto == null || dto.getData() == null || dto.getData().length == 0) {
            return true;
        }
        return false;
    }

    @Override
    public long getSize() {
        return dto.getSize();
    }

    @Override
    public byte[] getBytes() throws IOException {
        return dto.getData();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(dto.getData());
    }

    @Override
    public void transferTo(File dest) throws IOException {
        try(FileOutputStream outputStream = new FileOutputStream(dest)) {
            outputStream.write(dto.getData());
        }
    }

    public String getUploader() {
        return uploader;
    }

    public void setUploader(String uploader) {
        this.uploader = uploader;
    }
}
