package cn.gtmap.gtc.workflow.domain.manage;

import java.io.Serializable;
import java.util.Map;

/**
 * @author <a href="mailto:yuxinwang@gtmap.cn">yxw</a>
 * @version 1.0, 2018/6/11
 * @Description: 流程定义实体
 *
 */

@SuppressWarnings("serial")
public class ProcessDefData implements Serializable{

    private static final long serialVersionUID = 1L;
    //流程定义id
    protected String id;
    //流程定义名称
    protected String name;
    protected String description;
    //流程定义key
    protected String key;
    //流程定义版本
    protected int version;
    //流程定义类型名称
    protected String category;

    protected Map<String, Object> variables;

    protected int suspensionState ;
    //流程定义key,查询新建任务
    private String processDefKey;

    /**
     * 常用标识  0：否  1：是 (流程定义收藏标识)
     */
    private Integer commonUse;

    public Integer getCommonUse() {
        return commonUse;
    }

    public void setCommonUse(Integer commonUse) {
        this.commonUse = commonUse;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Map<String, Object> getVariables() {
        return variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public int getSuspensionState() {
        return suspensionState;
    }

    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    public String getProcessDefKey() {
        return processDefKey;
    }

    public void setProcessDefKey(String processDefKey) {
        this.processDefKey = processDefKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ProcessDefData that = (ProcessDefData) o;

        if (id != null ? !id.equals(that.id) : that.id != null) {
            return false;
        }

        return id != null ? id.equals(that.id) : that.id == null;

    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (id != null ? id.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ProcessDefData{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", description='" + description + '\'' +
                ", key='" + key + '\'' +
                ", version=" + version +
                ", category='" + category + '\'' +
                ", variables=" + variables +
                ", suspensionState=" + suspensionState +
                ", processDefKey='" + processDefKey + '\'' +
                '}';
    }
}
