package cn.gtmap.gtc.workflow.clients.statistics;

import cn.gtmap.gtc.workflow.domain.manage.StatisticsTaskDto;
import cn.gtmap.gtc.workflow.domain.statistics.*;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * Created by fjj on 2019/1/28.
 */
@FeignClient("${app.services.bpm-statistics:bpm-statistics}")
@RequestMapping("/rest/task-statistics/v1")
public interface TaskStatisticsClient {

    /**
     * 查询某用户待处理的任务超时统计情况
     *
     * @param userId
     * @return
     */
    @GetMapping(value = "/users/{userId}/active-tasks")
    List<StatisticsTaskDto> getActiveByUserId(@PathVariable("userId") String userId);

    /**
     * 查询所有部门的统计信息
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param category  业务类型
     * @param taskName  任务名称
     * @param statisticsType  StatisticsType Enum
     * @return
     */
    @GetMapping(value = "/orgs/statistics")
    List<OrgTaskStatisticsInfo> getStatisticsOfAllOrgs(@RequestParam(value = "startTime", required = false) Long startTime,
                                                       @RequestParam(value = "endTime", required = false) Long endTime,
                                                       @RequestParam(value = "category", required = false, defaultValue = "") String category,
                                                       @RequestParam(value = "taskName", required = false, defaultValue = "") String taskName,
                                                       @RequestParam(value = "statisticsType") String statisticsType);

    /**
     * 查询某个部门的统计信息
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param orgId     部门ID
     * @param category  业务类型
     * @param taskName  任务名称
     * @param statisticsType  StatisticsType Enum
     * @return
     */
    @GetMapping(value = "/users/statistics")
    List<UserTaskStatisticsInfo> getStatisticsByOrg(@RequestParam(value = "startTime", required = false) Long startTime,
                                                    @RequestParam(value = "endTime", required = false) Long endTime,
                                                    @RequestParam(value = "orgId", required = false, defaultValue = "") String orgId,
                                                    @RequestParam(value = "category", required = false, defaultValue = "") String category,
                                                    @RequestParam(value = "taskName", required = false, defaultValue = "") String taskName,
                                                    @RequestParam(value = "statisticsType") String statisticsType);


    /**
     * 按流程-节点统计流程各节点办理时间
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param orgId     部门ID
     * @param category  业务类型
     * @param taskName  任务名称
     * @return
     */
    @GetMapping(value = "/process/task/statistics/time")
    List<UserTaskStatisticsTimeDto> getUserStatisticsTime(@RequestParam(value = "startTime", required = false) Long startTime,
                                                                 @RequestParam(value = "endTime", required = false) Long endTime,
                                                                 @RequestParam(value = "orgId", required = false, defaultValue = "") String orgId,
                                                                 @RequestParam(value = "category", required = false, defaultValue = "") String category,
                                                                 @RequestParam(value = "taskName", required = false, defaultValue = "") String taskName);



    /**
     * 查询某用户的统计信息
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param username  登录名
     * @param category  业务类型
     * @param taskName  任务名称
     * @return
     */
    @GetMapping(value = "/users/{username}/statistics")
    List<BaseTaskStatisticsInfo> getStatisticsByUser(@RequestParam(value = "startTime") Long startTime,
                                                     @RequestParam(value = "endTime") Long endTime,
                                                     @PathVariable("username") String username,
                                                     @RequestParam(value = "category", required = false, defaultValue = "") String category,
                                                     @RequestParam(value = "taskName", required = false, defaultValue = "") String taskName);

    /**
     * 查询某用户的任务数量，管理员查询所有
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param username  登录名
     * @param dateType  查询时间类型， year，month,week,day
     * @param taskStatus  任务状态  1：待办任务， null: 全部任务
     * @return
     */
    @GetMapping(value = "/users/task/count")
    List<UserTaskCountDto> queryUserTaskCount(@RequestParam("username") String username,
                                                     @RequestParam(value = "taskStatus", required = false) Integer taskStatus,
                                                     @RequestParam(value = "startTime", required = false) Long startTime,
                                                     @RequestParam(value = "endTime",required = false) Long endTime,
                                                     @RequestParam(value = "dateType") String dateType);
}
