package cn.gtmap.gtc.workflow.clients.manage;

import cn.gtmap.gtc.workflow.domain.manage.CategoryProcessDto;
import cn.gtmap.gtc.workflow.domain.manage.OpinionDto;
import cn.gtmap.gtc.workflow.domain.manage.RuIdentitylink;
import cn.gtmap.gtc.workflow.domain.manage.TaskData;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:yuxinwang@gtmap.cn">yxw</a>
 * @version 1.0, 2018/7/11
 * @description 流程实例运行任务
 */

@FeignClient("${app.services.bpm-manage:bpm-manage}")
@RequestMapping("manage/v1")
public interface ProcessTaskClient {

    /**
     * 根据当前任务Id查询任务
     */
    @GetMapping("/process-tasks/{taskId}")
    TaskData getTaskById(@PathVariable("taskId") String taskId);


    /**
     * 流程实例当前运行的人工节点列表
     */
    @GetMapping(value = "/process-tasks/process-ins/current")
    List<TaskData> processRunningTasks(@RequestParam(value = "processInsId") String processInsId);

    /**
     * 流程实例当前运行的人工节点列表或最后一个节点列表
     */
    @GetMapping(value = "/process-tasks/process-ins/last")
    List<TaskData> processLastTasks(@RequestParam(value = "processInsId") String processInsId);

    /**
     * @param processInsId 流程实例ID
     * @return
     * @description 查询流程中任务列表
     */
    @GetMapping(value = "/process-tasks/process-ins/all")
    List<TaskData> listProcessTask(@RequestParam("processInsId")String processInsId);

    /**
     * 查询当前人员可新建的流程列表
     */
    @GetMapping("/process-tasks/category-process")
    List<CategoryProcessDto> listCategoryProcess(@RequestParam("username") String username);

    /**
     * 查询所有新建任务列表
     */
    @GetMapping("/process-tasks/all-category-process")
    List<CategoryProcessDto> listAllCategoryProcess();

    /**
     * 根据业务分类查询收藏的流程列表
     * @param username
     * @param processDefName
     * @param collectionType
     * @return
     */
    @GetMapping("/process-tasks/category-process-collection")
    Map<String, Object> listCollentionCategoryProcess(@RequestParam("username") String username,
                                                      @RequestParam(value = "processDefName",required = false) String processDefName,
                                                      @RequestParam("collectionType") String collectionType);

    /**
     * 新建任务列表
     */
    @GetMapping(value = "/process-tasks/{userId}/task-list-addition")
    HashMap<String, Object> taskCreateList(@PathVariable("userId") String userId);

    /**
     * 查询认领任务数量通知信息
     * @param username
     * @return TaskData
     */
    @GetMapping(value = "/process-tasks/claim/count")
    Integer claimTaskCount(@RequestParam(value = "username") String username);

    /**
     * 查询待办数量通知信息
     * @param username
     * @return TaskData
     */
    @GetMapping(value = "/process-tasks/todo/count")
    Integer todoTaskCount(@RequestParam(value = "username") String username);


    /**
     * 查询已办数量通知信息
     * @param username
     * @return TaskData
     */
    @GetMapping(value = "/process-tasks/complete/count")
    Integer completeTaskCount(@RequestParam(value = "username") String username,
                              @RequestParam(value = "startTime",required = false) Long startTime,
                              @RequestParam(value = "endTime",required = false) Long endTime);

    /**
     * 查询超期数量通知信息
     * @param username
     * @return TaskData
     */
    @GetMapping(value = "/process-tasks/time-out/count")
    Integer timeOutTaskCount(@RequestParam(value = "username") String username);

    /**
     * 认领任务列表
     * @param username
     * @param category
     * @param processInstanceName
     * @param pageable
     * @return
     */
    @GetMapping(value = "/process-tasks/task-list-unclaimed")
    Page<TaskData> claimTaskList(@RequestParam(value = "username",required = false) String username,
                                 @RequestParam(value = "category",required = false) String category,
                                 @RequestParam(value = "processInstanceName",required = false) String processInstanceName,
                                 Pageable pageable);

    /**
     * 待办任务列表
     * @param userId
     * @param category
     * @param processInstanceName
     * @param pageable
     * @return
     */
    @GetMapping(value = "/process-tasks/task-list-undoned")
    Page<TaskData> todoTaskList(@RequestParam(value = "userId",required = false) String userId,
                                @RequestParam(value = "category",required = false) String category,
                                @RequestParam(value = "processInstanceName",required = false) String processInstanceName,
                                Pageable pageable);



    /**
     * 已办任务列表
     * @param userId
     * @param category
     * @param processInstanceName
     * @param pageable
     * @return
     */
    @GetMapping(value = "/process-tasks/task-list-finished")
    Page<TaskData> completeTaskList(@RequestParam(value = "userId") String userId,
                                    @RequestParam(value = "category") String category,
                                    @RequestParam(value = "processInstanceName") String processInstanceName,
                                    Pageable pageable);


    /**
     * 根据taskId获取当前任务关联权限信息
     *
     * @return
     */
    @GetMapping(value = "/process-tasks/{taskId}/task-idm")
    List<RuIdentitylink> getIdentityByTaskId(@PathVariable("taskId") String taskId) throws Exception;


    /**
     * 取消认领任务
     *
     * @param taskId
     */
    @GetMapping(value = "/process-tasks/{taskId}/cancel-claim")
    boolean cancelTaskClaimBack(@PathVariable("taskId") String taskId);

    /**
     * 取回任务
     *
     * @param taskId
     */
    @Deprecated
    @GetMapping(value = "/process-tasks/{taskId}/fallback")
    String taskRecaption(@PathVariable("taskId") String taskId);


    /**
     * 流程实例管理列表
     *
     * @return
     */
    @GetMapping(value = "/processInstanceManage")
    Object createNativeProcessInstanceQuery();


    @PostMapping(value = "/task-variables/{taskId}")
    void addTaskVariables(@PathVariable("taskId") String taskId,@RequestParam("isLocal")Integer isLocal,@RequestBody Map<String, Object> vars);


    @GetMapping(value = "/task-variables/{taskId}")
    Map<String,Object> getTaskVariables(@PathVariable("taskId") String taskId,@RequestParam("isLocal")Integer isLocal);


    /**
     * @param processInsId: 流程实例Id
     * @param taskId: 任务ID
     * @param type: 意见类型 参考枚举CommentType
     * @return
     * @description 获取流程操作意见信息
     */
    @GetMapping(value = "/opinion")
    OpinionDto queryProcessOpinion(@RequestParam("processInsId")String processInsId,
                                          @RequestParam(value = "taskId", required = false)String taskId,
                                          @RequestParam("type")String type);
}
