package cn.gtmap.gtc.workflow.clients.define.v1;

import cn.gtmap.gtc.workflow.domain.define.Model;
import cn.gtmap.gtc.workflow.domain.define.dmn.DecisionTableDto;
import cn.gtmap.gtc.workflow.domain.define.dmn.DecisionTableSaveDto;
import cn.gtmap.gtc.workflow.domain.define.rest.ModelRepresentationView;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@FeignClient("${app.services.bpm-define:bpm-define}")
@RequestMapping("define/v1")
public interface DmnModelClient {

    /**
     * 根据决策表对id组获取决策列表
     * @param decisionTableIds
     * @return
     */
    @RequestMapping(
            value = {"/dmn-models/list"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public List<DecisionTableDto> getDecisionTables(@RequestBody String[] decisionTableIds);

    /**
     * 获取决策表详细数据
     * @param decisionTableId
     * @return
     */
    @RequestMapping(
            value = {"/dmn-models/{decisionTableId}"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public DecisionTableDto getDecisionTable(@PathVariable("decisionTableId") String decisionTableId);

    /**
     * 保存决策表的数据
     * @param decisionTableId
     * @param decisionTableSaveDto
     * @return
     */
    @RequestMapping(
            value = {"/dmn-models/{decisionTableId}"},
            method = {RequestMethod.POST},
            produces = {"application/json"}
    )
    public DecisionTableDto saveDecisionTable(@PathVariable("decisionTableId")String decisionTableId,@RequestParam("userId")String userId,@RequestBody DecisionTableSaveDto decisionTableSaveDto);

    /**
     * 根据条件获取case的列表
     * @return
     */
    @RequestMapping(
            value = {"/dmn-models"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    public List<Model> getDecisionTables(@RequestParam(value = "filter",required = false)String filter);

    /**
     * 模型的下载
     * @param modelId
     */
    @RequestMapping(
            value = {"/dmn-models/{modelId}/dmn"},
            method = {RequestMethod.GET}
    )
    public ResponseEntity<byte[]> getDmnModelBpmn20Xml(@PathVariable("modelId") String modelId) ;

    /**
     * 历史的模型的下载
     * @param modelHistoryId
     */
    @RequestMapping(
            value = {"/dmn-models/history/{modelHistoryId}/dmn"},
            method = {RequestMethod.GET}
    )
    public ResponseEntity<byte[]> getHistoricDmnBpmn20Xml(@PathVariable("modelHistoryId") String modelHistoryId);

    /**
     *BPMN的文件的上传
     * @param file
     * @return
     */
    @RequestMapping(
            value = {"/dmn-models/upload"}
    )
    @ResponseBody
    public ModelRepresentationView importDmnModel(@RequestParam("userId")String userId, @RequestParam("file") MultipartFile file);


    /**
     *BPMN的文件的上传（IE）
     * @param file
     * @return
     */
    @RequestMapping(
            value = {"/dmn-models/upload/text"},
            method = {RequestMethod.POST}
    )
    public String importDmnModelText(@RequestParam("userId")String userId,@RequestParam("file") MultipartFile file);

    /**
     *CMMN文件的部署
     * @return
     */
    @RequestMapping(
            value = {"/dmn-models/{modelId}/deployment"},
            method = {RequestMethod.GET}
    )
    public void deploymentDmn(@PathVariable("modelId")String modelId);

}
