/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.clients.define.v1;

import cn.gtmap.gtc.workflow.domain.define.rest.ModelRepresentationView;
import cn.gtmap.gtc.workflow.domain.rso.CaseModel;
import java.util.List;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@FeignClient(value="${app.services.bpm-define:bpm-define}")
@RequestMapping(value={"define/v1"})
public interface CmmnModelClient {
    @RequestMapping(value={"/case-models"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<CaseModel> getDecisionTables(@RequestParam(value="filter", required=false) String var1, @RequestParam(value="excludeId", required=false) String var2);

    @RequestMapping(value={"/case-models/{modelId}/cmmn"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> getProcessModelBpmn20Xml(@PathVariable(value="modelId") String var1);

    @RequestMapping(value={"/case-models/{modelId}/history/{modelHistoryId}/cmmn"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> getHistoricProcessModelBpmn20Xml(@PathVariable(value="modelId") String var1, @PathVariable(value="modelHistoryId") String var2);

    @RequestMapping(value={"/case-models/upload"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"}, consumes={"multipart/form-data"})
    public ModelRepresentationView importCaseModel(@RequestParam(value="userId") String var1, @RequestPart(value="file") MultipartFile var2);

    @RequestMapping(value={"/case-models/upload/text"}, method={RequestMethod.POST})
    public String importCaseModelText(@RequestParam(value="userId") String var1, @RequestParam(value="file") MultipartFile var2);

    @RequestMapping(value={"/case-models/{modelId}/deployment"}, method={RequestMethod.GET})
    public void deploymentCmmn(@PathVariable(value="modelId") String var1);
}

