package cn.gtmap.gtc.workflow.enums.task;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/3/6
 * @description 委托状态
 */
public enum  DelegationStatus {

    NONE("未代理"),

    PENDING("代理中"),

    RESOLVED("已解决");

    private String remark;

    public String getRemark() {
        return remark;
    }

    DelegationStatus(String remark) {
        this.remark = remark;
    }

    public static String getStatusName(String code){
        if ("NONE".equals(code)){
            return "未代理";
        }else if ("PENDING".equals(code)) {
            return "代理中";
        }else if ("RESOLVED".equals(code)) {
            return "已解决";
        }
        return null;
    }
}
