package cn.gtmap.gtc.workflow.enums.manage;

public enum QueryKey {

    /**
     * 任务ID相等条件
     */
    TASKID_EQ("taskId_eq"),

    /**
     * 任务受理人， 用户username, 查询待办已办时，必传
     */
    TASKASSIGIN_EQ("taskAssigin_eq"),

    /**
     *相等条件的任务节点id
     */
    TASKKEY_EQ ("taskKey_eq"),

    /*
     *相等条件的任务节点id
     */
    TASKNAME_EQ("taskName_eq"),

    /**
     *相等条件的开始时间
     */
    STARTTIME_EQ ("startTime_eq"),

    /**
     *相等条件的流程实例
     */
    PROCESSINSTANCEID_EQ ("processInstanceId_eq"),

    /**
     *相等条件的的流程实例名称
     */
    PROCESSINSTANCENAME_EQ ("processInstanceName_eq"),

    /**
     *流程状态 匹配
     */
    PROCSTATUS_EQ("procStatus_eq"),

    /**
     *相等条件的任务结束时间
     */
    ENDTIME_EQ ("endTime_eq"),

    /**
     *相等条件的优先级
     */
    PRIORITY_EQ ("priority_eq"),

    /**
     *流程实例启动人ID（对应用户中心的）
     *
     * 对用用户权限中心 username
     */
    STARTUSERID_EQ ("startUserId_eq"),
    /**
     *流程实例启动人姓名
     *
     */
    STARTUSERNAME_EQ ("startUserName_eq"),
    /**
     *流程定义ID的相等条件
     */
    PROCESSDEFID_EQ ("processDefId_eq"),

    /**
     *流程定义唯一标识的相等条件
     */
    PROCESSKEY_EQ ("processKey_eq"),

    /**
     *流程定义的名称的相等条件
     */
    PROCESSDEFNAME_EQ ("processDefName_eq"),

    /**
     *任务状态的相等条件
     */
    STATE_EQ ("state_eq"),

    /**
     *委托状态的相等条件
     */
    DELEGATION_EQ ("delegation_eq"),

    /**
     *流程业务类别的相等条件
     */
    CATEGORY_EQ ("category_eq"),

    /**
     *任务到期天数的相等条件
     */
    TASKDUEDAYS_EQ ("taskDueDays_eq"),

    /**
     *任务到期时数的相等条件
     */
    TASKDUEHOURS_EQ ("taskDueHours_eq"),

    /**
     *任务超期天数的相等条件
     */
    TASKTIMEOUTDAYS_EQ ("taskTimeoutDays_eq"),

    /**
     *任务超期时数的相等条件
     */
    TASKTIMEOUTHOURS_EQ ("taskTimeoutHours_eq"),

    /**
     *项目ID的相等条件
     */
    PROJECTID_EQ ("projectId_eq"),

    /**
     *项目的名称的相等条件
     */
    PROJECTNAME_EQ  ("projectName_eq"),

    /**
     *自定义的文本1的相等条件
     */
    TEXT1_EQ  ("text1_eq"),

    /**
     *自定义的文本2的相等条件
     */
    TEXT2_EQ ("text2_eq"),

    /**
     *自定义的文本3的相等条件
     */
    TEXT3_EQ ("text3_eq"),

    /**
     *自定义的文本4的相等条件
     */
    TEXT4_EQ ("text4_eq"),

    /**
     *自定义的文本5的相等条件
     */
    TEXT5_EQ ("text5_eq"),

    /**
     *自定义的文本6的相等条件
     */
    TEXT6_EQ ("text6_eq"),

    /**
     *自定义的文本7的相等条件
     */
    TEXT7_EQ ("text7_eq"),

    /**
     *自定义的文本8的相等条件
     */
    TEXT8_EQ ("text8_eq"),

    /**
     *自定义的文本9的相等条件
     */
    TEXT9_EQ ("text9_eq"),

    /**
     *自定义的int1的相等条件
     */
    NIM1_EQ ("num1_eq"),

    /**
     *自定义的int2的相等条件
     */
    NUM2_EQ ("num2_eq"),

    /**
     *自定义的文日期1的相等条件
     */
    DATE1_EQ ("date1_eq"),

    /**
     *自定义的日期2的相等条件
     */
    DATE2_EQ("date2_eq"),

    /**
     *任务受理人名称相似
     */
    TASKASSIGIN_LIKE ("taskAssigin_like"),

    /**
     *任务名称的相似查询
     */
    TASKNAME_LIKE ("taskName_like"),

    /**
     *流程实例名称的相似查询
     */
    PROCESSINSTANCENAME_LIKE ("processInstanceName_like"),

    /**
     *流程定义名称的相似查询
     */
    PROCESSDEFNAME_LIKE ("processDefName_like"),

    /**
     *项目名称的相似查询
     */
    PROJECTNAME_LIKE ("projectName_like"),
    /**
     *流程实例启动人姓名
     *
     */
    STARTUSERNAME_LIKE ("startUserName_like"),

    /**
     *自定义文本1相似查询
     */
    TEXT1_LIKE ("text1_like"),

    /**
     *自定义文本2相似查询
     */
    TEXT2_LIKE ("text2_like"),

    /**
     *自定义文本3相似查询
     */
    TEXT3_LIKE ("text3_like"),

    /**
     *自定义文本4相似查询
     */
    TEXT4_LIKE ("text4_like"),

    /**
     *自定义文本5相似查询
     */
    TEXT5_LIKE ("text5_like"),

    /**
     *自定义文本6相似查询
     */
    TEXT6_LIKE ("text6_like"),

    /**
     *自定义文本7相似查询
     */
    TEXT7_LIKE ("text7_like"),

    /**
     *自定义文本8相似查询
     */
    TEXT8_LIKE ("text8_like"),

    /**
     *自定义文本9相似查询
     */
    TEXT9_LIKE ("text9_like"),

    /**
     *开始时间的不等于查询
     */
    STARTTIME_NEQ ("startTime_neq "),

    /**
     *开始时间的大于查询
     */
    STARTTIME_GT  ("startTime_gt"),

    /**
     *开始时间的大于等于询
     */
    STARTTIME_EGT  ("startTime_egt"),

    /**
     *开始时间的小于
     */
    STARTTIME_LT ("startTime_lt"),

    /**
     *开始时间的小于等于
     */
    STARTTIME_ELT ("startTime_elt"),

    /**
     *结束时间的小于等于
     */
    ENDTIME_ELT ("endTime_elt"),

    /**
     *结束时间的大于等于询
     */
    ENDTIME_EGT  ("endTime_egt"),

    /**
     *自定义时间的不等于
     */
    DATE1_NEQ ("date1_neq"),

    /**
     *自定义时间的大于
     */
    DATE1_GT ("date1_gt"),

    /**
     *自定义时间的大于等于
     */
    DATE1_EGT ("date1_egt"),

    /**
     *自定义时间的小于
     */
    DATE1_LT ("date1_lt"),

    /**
     *自定义时间的小于等于
     */
    DATE1_ELT ("date1_elt"),

    /**
     *自定义时间的不等于
     */
    DATE2_NEQ ("date2_neq"),

    /**
     *自定义时间的大于
     */
    DATE2_GT ("date2_gt"),

    /**
     *自定义时间的大于等于
     */
    DATE2_EGT ("date2_egt"),

    /**
     *自定义时间的小于
     */
    DATE2_LT ("date2_lt"),

    /**
     *自定义时间的小于等于
     */
    DATE2_ELT ("date2_elt"),

    /**
     *开始时间的降序
     */
    STARTTIME_DESC ("startTime_desc"),

    /**
     *开始时间升序
     */
    STARTTIME_ASC ("startTime_asc"),

    /**
     *组织ID等于
     */
    TASK_ORG_ID_EQ("taskOrg_eq"),

    /**
     *组织ID模糊收索
     */
    TASK_ORG_ID_LIKE("taskOrg_like"),

    /**
     *用户名 列表查询
     */
    TASKASSIGIN_IN("taskAssigin_in"),

    /**
     *流程定义名称列表查询
     */
    PROCESSDEFNAME_IN ("processDefName_in"),

    /**
     *角色列表查询
     */
    TASK_ROLE_ID_IN("taskAssRoleId_in");


    private final String value;

    QueryKey(String v){
        value = v;
    }

    public String value() {
        return value;
    }
}
