package cn.gtmap.gtc.workflow.clients.manage;


import cn.gtmap.gtc.workflow.domain.manage.CountersignTaskDto;
import cn.gtmap.gtc.workflow.domain.manage.ProcessInstanceData;
import cn.gtmap.gtc.workflow.domain.manage.TaskData;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;


/**
 * @author <a href="mailto:yuxinwang@gtmap.cn">yxw</a>
 * @version 1.0, 2018/7/11
 * @description 流程实例管理
 *
 */

@FeignClient(name = "${app.services.bpm-manage:bpm-manage}")
@RequestMapping("manage/v1")
public interface ProcessInstanceClient {

    @RequestMapping(value = "/process-instances",method = RequestMethod.GET)
    Object contentpagelist() throws Exception;

    /**
     * 流程实例的启动
     * @param processDefKey             流程定义的唯一标识符
     * @param userName                  用户名
     * @param workDayId                 可选工作日关联Id（如果流程的启动配置没有关联工作日，请填值，不然会抛异常）
     * @param processInstanceName      可选 流程实例的名称
     * @param priority                  可选  流程任务优先级 不填默认一般
     * @param desc                      可选   流程描述
     * @return
     * @throws
     */
    @PostMapping("/process-instances/startUp")
    TaskData startUpProcess(@RequestParam(value = "processDefKey") String processDefKey,
                                   @RequestParam(value = "userName") String userName,
                                   @RequestParam(value = "workDayId",required = false) String workDayId,
                                   @RequestParam(value = "processInstanceName",required = false) String processInstanceName,
                                   @RequestParam(value = "priority",required = false) Integer priority,
                                   @RequestParam(value = "category") String category,
                                   @RequestParam(value = "department") String department,
                                   @RequestParam(value = "procDueLimt") Integer procDueLimt,
                                   @RequestParam(value = "isPriority") Integer isPriority,
                                   @RequestParam(value = "desc",required = false) String desc);

    /**
     * 直接启动流程实例
     * @param processDefKey             流程定义的唯一标识符
     * @param userName                  用户名
     * @return
     * @throws Exception
     */
    @PostMapping("/process-instances/direct-startUp")
    TaskData directStartProcessInstance(@RequestParam(value = "processDefKey") String processDefKey,
                                                @RequestParam(value = "userName") String userName,
                                                @RequestParam(value = "processInstanceName",required = false) String processInstanceName);

    /**
     * 设定默认启动角色
     * @param processDefKey             流程定义的唯一标识符
     * @param roleCodes    角色编码， 英文逗号间隔
     * @return
     * @throws Exception
     */
    @PostMapping("/process-instances/role-startUp")
    TaskData directStartByRole(@RequestParam(value = "processDefKey") String processDefKey,
                                      @RequestParam(value = "roleCodes", required = false) String roleCodes,
                                      @RequestParam(value = "processInstanceName",required = false) String processInstanceName);

    /**
     * 创建流程变量，设置变量值
     * @param executionId
     * @param variableName
     * @param variableValue
     * @return
     */
    @RequestMapping(value = "/process-instances/{executionId}/{variableName}/{variableValue}/variable",method = RequestMethod.POST)
    void createOrUpdateVariable(@PathVariable("executionId") String executionId,
                                       @PathVariable("variableName") String variableName,
                                       @PathVariable("variableValue") Object variableValue);

    /**
     * 根据executionId和variableName获取variable对象
     * @param executionId
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/process-instances/{executionId}/{variableName}/variable",method = RequestMethod.GET)
    Object getVariable(@PathVariable("executionId") String executionId,
                              @PathVariable("variableName") String variableName);

    /**
     * 根据executionId获取所有variables对象
     * @param executionId
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/process-instances/{executionId}/variables",method = RequestMethod.GET)
    Map getVariables(@PathVariable("executionId") String executionId);

    /**
     * 删除流程变量
     * @param executionId
     * @param variableName
     * @throws Exception
     */
    @RequestMapping(value = "/process-instances/{executionId}/{variableName}",method = RequestMethod.DELETE)
    void deleteVariable(@PathVariable("executionId") String executionId,
                               @PathVariable("variableName") String variableName);

    /**
     * 流程实例在线编辑
     * @param countersignTaskDtoList
     * @return
     */
    @RequestMapping(value = "/process-instances/proInsEdit",method = RequestMethod.POST)
    @ResponseBody
    int processInstanceEdit(@RequestBody List<CountersignTaskDto> countersignTaskDtoList);

    /**
     * 流程任意节点跳转
     * @param taskId
     * @param targetNodeId
     */
    @RequestMapping(value = "/process-instances/{taskId}/{targetNodeId}/arbitrary-node-jump",method = RequestMethod.POST)
    void arbitraryNodeJump(@PathVariable("taskId") String taskId,
                                  @PathVariable("targetNodeId") String targetNodeId);

    /**
     * 设置优先级
     * @param taskId
     * @param priorityInt
     */
    @RequestMapping(value = "/process-instances/{taskId}/{priority}/priority-set",method = RequestMethod.POST)
    String setProcessPriority(@PathVariable("taskId") String taskId,
                                   @PathVariable("priority") int priorityInt);

    /**
     * 获取流程实例
     * @param processInstanceId
     * @return
     */
    @RequestMapping(value = "/process-instances/{processInstanceId}/processInstance",method = RequestMethod.GET)
    ProcessInstanceData getProcessInstance(@PathVariable("processInstanceId") String processInstanceId);


    /**
     * 流程实例名称修改
     * @param processInstanceId
     * @param processInstanceName
     * @throws Exception
     */
    @RequestMapping(value = "/process-instances/name",method = RequestMethod.GET)
    public void processInstanceEdit(@RequestParam("processInstanceId")String processInstanceId,@RequestParam("processInstanceName") String processInstanceName);
}
