package cn.gtmap.gtc.workflow.clients.define.v1;

import cn.gtmap.gtc.workflow.domain.define.ReceiptDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 *@Author fangyinwei
 *@Date 2019/8/1
 *@Time
 *@Description 收件单client
 */
@FeignClient("${app.services.bpm-define:bpm-define}")
@RequestMapping("define/v1")
public interface ReceiptClient {

    /**
     * 根据主键查询收件单
     * @param id 主键
     * @return
     */
    @GetMapping("/receipt/")
    ReceiptDto findOne(@RequestParam("id") String id);

    /**
     * 根据条件查询收件单列表
     * @param receiptDtoJsonStr receiptDto的json字符串
     * @return
     */
    @GetMapping("/receipt/list")
    List<ReceiptDto> findListByJsonStr(@RequestParam("receiptDtoJsonStr") String receiptDtoJsonStr);


    /**
     * 根据条件查询收件单列表分页
     * @param pageable
     * @param receiptDtoJsonStr receiptDto的json字符串
     * @return
     */
    @GetMapping("/receipt/page")
    Page<ReceiptDto> findPageByJsonStr(Pageable pageable, @RequestParam("receiptDtoJsonStr") String receiptDtoJsonStr);


    /**
     * 新增收件单
     * @param receiptDto
     * @return
     */
    @PostMapping("/receipt/")
    ReceiptDto addOne(@RequestBody ReceiptDto receiptDto);

    /**
     * 批量新增
     * @param receiptDtoList
     * @return
     */
    @PostMapping("/receipt/batch")
    List<ReceiptDto> batchAdd(@RequestBody List<ReceiptDto> receiptDtoList);

    /**
     * 根据条件更新收件单
     * @param receiptDto
     * @return
     */
    @PatchMapping("/receipt/")
    ReceiptDto update(@RequestBody ReceiptDto receiptDto);

    /**
     * 根据主键删除收件单
     * @param id 主键
     * @return
     */
    @DeleteMapping("/receipt/")
    boolean deleteOne(@RequestParam("id") String id);
}
