package cn.gtmap.gtc.workflow.clients.define.v1;

import cn.gtmap.gtc.workflow.domain.define.NoticeDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

/**
 * @author zhouk
 * @Title: NoticeClient
 * @ProjectName workflow
 * @Description: TODO
 * @date 2018/12/69:00
 */
@FeignClient("${app.services.bpm-define:bpm-define}")
@RequestMapping("define/v1")
public interface NoticeClient {
    /**
     *
     * 根据名称模糊搜素通知列表
     * @param name
     * @param page
     * @return
     */
    @RequestMapping(
            value = {"/notice/page"},
            method = {RequestMethod.GET}
    )
    public Page<NoticeDto> queryNoticesPage(@RequestParam(value = "name",required = false) String name, Pageable page);

    /**
     * 获取通知的详细
     * @param Id
     * @return
     */
    @RequestMapping(
            value = {"/notice/{Id}"},
            method = {RequestMethod.GET}
    )
    public NoticeDto getNotice(@PathVariable("Id") String Id);

    /**
     * 新增通知
     * @param noticeDto
     */
    @RequestMapping(
            value = {"/notice"},
            method = {RequestMethod.POST}
    )
    public void InsertNotice(@RequestBody NoticeDto noticeDto);

    /**
     * 更新通知的公告
     * @param noticeDto
     */
    @RequestMapping(
            value = {"/notice"},
            method = {RequestMethod.PATCH}
    )
    public void updateNotice(@RequestBody NoticeDto noticeDto);
    /**
     * 删除公告
     * @param Id
     */
    @RequestMapping(
            value = {"/notice/{Id}"},
            method = {RequestMethod.DELETE}
    )
    public void delNotice(@PathVariable("Id") String Id);
}
