/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.clients.manage;

import cn.gtmap.gtc.workflow.domain.common.ProcessOptResultDto;
import cn.gtmap.gtc.workflow.domain.manage.BackTaskDto;
import cn.gtmap.gtc.workflow.domain.manage.ForwardTaskDto;
import java.util.List;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${app.services.bpm-manage:bpm-manage}")
@RequestMapping(value={"manage/v1"})
public interface TaskHandleClient {
    @DeleteMapping(value={"/task-handel/{taskId}"})
    public boolean deleteTask(@PathVariable(value="taskId") String var1);

    @DeleteMapping(value={"/task-handel/process/{processInstanceId}"})
    public boolean deleteProcess(@PathVariable(value="processInstanceId") String var1);

    @DeleteMapping(value={"/task-handel/process"})
    public boolean deleteProcessWithReason(@RequestParam(value="processInstanceId") String var1, @RequestParam(value="reason", required=false) String var2);

    @PostMapping(value={"/task-handel/{taskId}/finish"})
    public boolean processEndOfMandatory(@PathVariable(value="taskId") String var1);

    @PostMapping(value={"/task-handel/{processInstanceId}/task-discard"})
    public boolean taskAbandoned(@PathVariable(value="processInstanceId") String var1, @RequestParam(value="deleteReason", required=false) String var2);

    @PostMapping(value={"/task-handel/{processInstanceId}/task-suspension"})
    public boolean taskHang(@PathVariable(value="processInstanceId") String var1, @RequestParam(value="reason", required=false) String var2);

    @PostMapping(value={"/task-handel/{processInstanceId}/task-activate"})
    public boolean taskActivation(@PathVariable(value="processInstanceId") String var1, @RequestParam(value="reason", required=false) String var2);

    @PostMapping(value={"/task-handel/{taskId}/locked"})
    public boolean taskLock(@PathVariable(value="taskId") String var1, @RequestParam(value="username") String var2);

    @PostMapping(value={"/task-handel/{taskId}/unlocked"})
    public boolean taskUnLock(@PathVariable(value="taskId") String var1);

    @PostMapping(value={"/task-handel/{taskId}/delegation"})
    public boolean taskDelegation(@PathVariable(value="taskId") String var1, @RequestParam(value="username") String var2);

    @PostMapping(value={"/task-handel/claim"})
    public boolean taskClaim(@RequestParam(value="username") String var1, @RequestBody List<String> var2);

    @PostMapping(value={"/task-handel/forward/complete"})
    public boolean complete(@RequestBody List<ForwardTaskDto> var1);

    @PostMapping(value={"/task-handel/forward/end"})
    public boolean processEnd(@RequestBody ForwardTaskDto var1);

    @PostMapping(value={"/task-handel/back/complete"})
    public boolean back(List<BackTaskDto> var1);

    @PostMapping(value={"/task-handel/batch-forward/complete"})
    public List<ProcessOptResultDto> batchComplete(@RequestParam(value="taskIds") String var1, @RequestBody(required=false) List<ForwardTaskDto> var2);

    @PostMapping(value={"/task-handel/fetchBack/complete/{taskId}"})
    public boolean fetchBack(@PathVariable(name="taskId") String var1);
}

