package cn.gtmap.gtc.workflow.enums.variable;

/**
 * @author <a href="mailto:xuchao@gtmap.cn">xuchao</a>
 * @version 1.0.2019/3/1
 * @description 表单属性key配置
 */
public enum CustomActivityProperty {
    BACK_COMPENSATION_URL("BACK_COMPENSATION_URL","补偿服务地址"),
    BACK_COMPENSATION_URL_METHOD("BACK_COMPENSATION_URL_METHOD","补偿方法类型"),
    BACK_COMPENSATION_URL_REQUEYSTBODY("BACK_COMPENSATION_URL_REQUEYSTBODY","补偿请求体"),
    IS_SIGN("IS_SIGN","是否签名"),
    IS_BACK("IS_BACK","是否允许回退"),
    SAME_PEOPLE_ACTIVITY_ID("SAME_PEOPLE_ACTIVITY_ID","相同办理节点"),
    DNEXT_DISPATCH_STATEGY("DNEXT_DISPATCH_STATEGY","下节点派件策略"),

    BEFORE_FORWARD_URL("BEFORE_FORWARD_URL","转发前验证地址"),
    BEFORE_FORWARD_URL_METHOD("BEFORE_FORWARD_URL_METHOD","转发前方法类型"),
    BEFORE_FORWARD_URL_REQUEYSTBODY("BEFORE_FORWARD_URL_REQUEYSTBODY","转发前验证请求体"),

    BEFORE_DELETE_URL("BEFORE_DELETE_URL","删除前验证地址"),
    BEFORE_DELETE_URL_METHOD("BEFORE_DELETE_URL_METHOD","删除前方法类型"),
    BEFORE_DELETE_URL_REQUEYSTBODY("BEFORE_DELETE_URL_REQUEYSTBODY","删除前验证请求体")
    ;

    private String value;
    private String label;

    private CustomActivityProperty(String value, String label){
        this.value = value;
        this.label = label;
    }

    public static CustomActivityProperty valueOf(int value) {
        for (CustomActivityProperty customActivityKey : values()) {
            if (customActivityKey.getValue().equals(value)) {
                return customActivityKey;
            }
        }
        return null;
    }

    public String getValue() {
        return value;
    }

    public String getLabel() {
        return label;
    }
}
