package cn.gtmap.gtc.workflow.clients.statistics;

import cn.gtmap.gtc.workflow.domain.statistics.MyProcData;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 我的流程
 *
 * @author Fjj
 * @date 2018/7/16
 */
@FeignClient("${app.services.bpm-statistics:bpm-statistics}")
@RequestMapping("/rest/my-proc/v1")
public interface MyProcClient {

    /**
     * 分页查询由用户发起的流程
     *
     * @param userId
     * @param category
     * @param processInstanceName
     * @param pageable
     * @return
     */
    @GetMapping(value = "/starter")
    Page<MyProcData> queryAsStarterByPage(@RequestParam(value = "userId") String userId,
                                          @RequestParam(value = "category", required = false, defaultValue = "") String category,
                                          @RequestParam(value = "processInstanceName", required = false, defaultValue = "")
                                                  String processInstanceName, Pageable pageable);

    /**
     * 分页查询用户参与的流程
     *
     * @param userId
     * @param category
     * @param processInstanceName
     * @param pageable
     * @return
     */
    @GetMapping(value = "/participant")
    Page<MyProcData> queryAsParticipantByPage(@RequestParam(name = "userId") String userId, @RequestParam(name = "category", required = false, defaultValue = "") String category,
                                              @RequestParam(name = "processInstanceName", required = false, defaultValue = "") String processInstanceName, Pageable pageable);

}
