package cn.gtmap.gtc.workflow.clients.define.v2;

import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.workflow.domain.define.ProcessDefinedDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zhouk
 * @Title: ProcessDefineClient
 * @ProjectName workflow
 * @Description: TODO
 * @date 2018/9/2617:30
 */
@FeignClient("${app.services.bpm-define:bpm-define}")
@RequestMapping("define/v2")
public interface ProcessDefineClient {

    /**
     * 获取流程的定义（已发布的模版的最新的一个）
     * @return
     */
    @RequestMapping(
            value = {"/process-defines/page"},
            method = {RequestMethod.GET}
    )
    public PageResult<ProcessDefinedDto> getProcessDefines(@RequestParam(required =false,value = "name") String name,
                                                           Pageable pageable);

    /**
     * 流程定义的历史
     * @param key
     * @return
     */
    @RequestMapping(
            value = {"/process-defines/historys"},
            method = {RequestMethod.GET}
    )
    public PageResult<ProcessDefinedDto> getHistoryProcess(@RequestParam("key")String key,
                                                           Pageable pageable);
}
