/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.utils;

import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtils.class);

    public static Calendar toCalendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar toCalendar(String s, DateFormatType dateFormatType) throws ParseException {
        if (dateFormatType == DateFormatType.DATETIME) {
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return DateUtils.toCalendar(dateTimeFormat.parse(s));
        }
        if (dateFormatType == DateFormatType.DATE) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            return DateUtils.toCalendar(dateFormat.parse(s));
        }
        return null;
    }

    public static Date toData(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day);
        return calendar.getTime();
    }

    public static Date toData(Calendar calendar) {
        return calendar.getTime();
    }

    public static Date toDate(String date, DateFormatType dateFormatType) throws ParseException {
        if (dateFormatType == DateFormatType.DATETIME) {
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return dateTimeFormat.parse(date);
        }
        if (dateFormatType == DateFormatType.DATE) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            return dateFormat.parse(date);
        }
        return null;
    }

    public static int calcDayOffset(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return DateUtils.calcDayOffset(cal1, cal2);
    }

    public static int calcDayOffset(Calendar cal1, Calendar cal2) {
        int year2;
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        if (year1 != (year2 = cal2.get(1))) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                boolean isLeapYear;
                boolean bl = isLeapYear = i % 4 == 0 && i % 100 != 0 || i % 400 == 0;
                if (isLeapYear) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (day2 - day1);
        }
        return day2 - day1;
    }

    boolean isSameDay(Calendar cal1, Calendar cal2) {
        return cal1.get(2) == cal2.get(2) && cal1.get(5) == cal2.get(5) && cal1.get(1) == cal2.get(1);
    }

    public static Time toTime(String strDate) {
        String str = strDate;
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        Date d = null;
        try {
            d = format.parse(str);
            return new Time(d.getTime());
        }
        catch (Exception e) {
            LOGGER.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    public static int getTimeDifferenceInMinutesByTime(String startTime, String endTime) {
        Time start = DateUtils.toTime(startTime);
        Time end = DateUtils.toTime(endTime);
        if (start != null && end != null) {
            return DateUtils.getTimeDifferenceInMinutesByTime(start, end);
        }
        return 0;
    }

    public static int getTimeDifferenceInMinutesByTime(Time startTime, Time endTime) {
        return (int)((endTime.getTime() - startTime.getTime()) / 60000L);
    }

    public static int getTimeDifferenceInMinutesByDate(Date startTime, Date endTime) {
        return (int)((endTime.getTime() - startTime.getTime()) / 60000L);
    }

    public static int getTimeDifferenceInHoursByDate(Date startTime, Date endTime) {
        return (int)((endTime.getTime() - startTime.getTime()) / 3600000L);
    }

    public static Calendar addDays(Calendar calendar, int days) {
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(calendar.getTimeInMillis());
        result.add(5, days);
        return result;
    }

    public static Calendar addHours(Calendar calendar, int hours) {
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(calendar.getTimeInMillis());
        result.add(11, hours);
        return result;
    }

    public static Calendar addMinutes(Calendar calendar, int i) {
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(calendar.getTimeInMillis());
        result.add(12, i);
        return result;
    }

    public static enum DateFormatType {
        DATE("yyyy-MM-dd"),
        DATETIME("yyyy-MM-dd HH:mm:ss");

        String format;

        private DateFormatType(String format) {
            this.format = format;
        }
    }
}

