package cn.gtmap.gtc.workflow.entity;

import cn.gtmap.gtc.workflow.Constant;
import cn.gtmap.gtc.workflow.domain.manage.StatisticsProcDto;
import cn.gtmap.gtc.workflow.utils.BeanUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.springframework.util.StringUtils;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 流程统计BEAN
 *
 * @author fjj
 */
@Table(name = "ACT_ST_PROC")
public class StatisticsProc implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @Id
    private String id;

    /**
     * 流程实例ID
     */
    private String procInsId;

    /**
     * 流程定义ID
     */
    private String procDefId;

    /**
     * 流程定义key
     */
    private String procDefKey;

    /**
     * 流程期限类型(D 按天,H 按小时,N 不限制)
     */
    private String procDueType = "D";

    /**
     * 流程期限
     */
    private Integer procDueLimit;

    /**
     * 流程开始时间
     */
    private Date procStartTime;

    /**
     * 流程到期时间
     */
    private Date procDueTime;

    /**
     * 流程结束时间
     */
    private Date procEndTime;

    /**
     * 流程发起人编码(登录名)
     */
    private String startUserId;

    /**
     * 发起人所属部门ID
     */
    private String startUserDep;

    /**
     * 流程发起人名称(中文名)
     */
    private String startUserName;

    /*
    *  最后一次计算时间
    * */
    private Date reckonTime;

    /**
     * 流程超期量(单位由PROC_DUE_TYPE决定)
     */
    private Integer procTimeoutCount;

    /**
     * 流程超期状态(0未超期,1已超期)
     */
    private Integer procTimeoutStatus;

    /**
     * 流程状态(1正在运行，2结束)
     */
    private Integer procStatus;

    /**
     * 业务类别
     */
    private String category;

    /*
     *  工作日ID
     * */
    private String workId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProcInsId() {
        return procInsId;
    }

    public void setProcInsId(String procInsId) {
        this.procInsId = procInsId;
    }

    public String getProcDefId() {
        return procDefId;
    }

    public void setProcDefId(String procDefId) {
        this.procDefId = procDefId;
    }

    public String getProcDefKey() {
        return procDefKey;
    }

    public void setProcDefKey(String procDefKey) {
        this.procDefKey = procDefKey;
    }

    public String getProcDueType() {
        return procDueType;
    }

    public void setProcDueType(String procDueType) {
        this.procDueType = procDueType;
    }

    public Integer getProcDueLimit() {
        return procDueLimit;
    }

    public void setProcDueLimit(Integer procDueLimit) {
        this.procDueLimit = procDueLimit;
    }

    public Date getProcStartTime() {
        return procStartTime;
    }

    public void setProcStartTime(Date procStartTime) {
        this.procStartTime = procStartTime;
    }

    public Date getProcDueTime() {
        return procDueTime;
    }

    public void setProcDueTime(Date procDueTime) {
        this.procDueTime = procDueTime;
    }

    public Date getProcEndTime() {
        return procEndTime;
    }

    public void setProcEndTime(Date procEndTime) {
        this.procEndTime = procEndTime;
    }

    public String getStartUserId() {
        return startUserId;
    }

    public void setStartUserId(String startUserId) {
        this.startUserId = startUserId;
    }

    public String getStartUserDep() {
        return startUserDep;
    }

    public void setStartUserDep(String startUserDep) {
        this.startUserDep = startUserDep;
    }

    public String getStartUserName() {
        return startUserName;
    }

    public void setStartUserName(String startUserName) {
        this.startUserName = startUserName;
    }

    public Date getReckonTime() {
        return reckonTime;
    }

    public void setReckonTime(Date reckonTime) {
        this.reckonTime = reckonTime;
    }

    public Integer getProcTimeoutCount() {
        return procTimeoutCount;
    }

    public void setProcTimeoutCount(Integer procTimeoutCount) {
        this.procTimeoutCount = procTimeoutCount;
    }

    public Integer getProcTimeoutStatus() {
        return procTimeoutStatus;
    }

    public void setProcTimeoutStatus(Integer procTimeoutStatus) {
        this.procTimeoutStatus = procTimeoutStatus;
    }

    public Integer getProcStatus() {
        return procStatus;
    }

    public void setProcStatus(Integer procStatus) {
        this.procStatus = procStatus;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Long getProcStartTimeInLong() {
        return procStartTime == null ? null : procStartTime.getTime() - Constant.B_UTC;
    }

    public Long getProcEndTimeInLong() {
        return procEndTime == null ? null : procEndTime.getTime() - Constant.B_UTC;
    }

    public List<String> getStartUserDepList() {
        List<String> list;
        if (StringUtils.isEmpty(startUserDep)) {
            list = new ArrayList<>();
            list.add("");
        } else {
            list = Arrays.asList(startUserDep.split(Constant.EN_COMMA));
        }
        return list;
    }

    public String getWorkId() {
        return workId;
    }

    public void setWorkId(String workId) {
        this.workId = workId;
    }

    public StatisticsProc() {
    }

    public StatisticsProc(StatisticsProcDto statisticsProcDto) {
        BeanUtil.copyBean(statisticsProcDto, this);
    }

    @JsonIgnore
    public StatisticsProcDto getBean() {
        StatisticsProcDto statisticsProcDto = new StatisticsProcDto();
        BeanUtil.copyBean(this, statisticsProcDto);
        return statisticsProcDto;
    }
}