package cn.gtmap.gtc.workflow.domain.manage;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zk
 */
public class StatisticsTaskDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 任务id
     */
    private String taskId;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 流程定义id
     */
    private String procDefId;

    /**
     * 流程定义key
     */
    private String procDefKey;

    /**
     * 流程实例id
     */
    private String procInsId;

    /**
     * 任务发起人部门id
     */
    private String taskAssDepId;

    /**
     * 任务发起人角色id
     */
    private String taskAssRoleId;

    /**
     * 任务发起人id
     */
    private String taskAssId;

    /**
     * 任务开始时间
     */
    private Date taskStartDate;

    /**
     * 任务到期天数
     */
    private Integer taskDueDays;

    /**
     * 任务到期小时数
     */
    private Integer taskDueHours;

    /**
     * 任务实际到期时间
     */
    private Date taskDueDate;

    /**
     * 任务结束时间
     */
    private Date taskEndDate;

    /**
     * 任务超期天数
     */
    private Integer taskTimeoutDays;

    /**
     * 任务超期时数
     */
    private Integer taskTimeoutHours;

    /**
     * 任务状态（1在线，2挂起， 3：锁定，4 结束）
     */
    private Integer taskStatus;

    /**
     * 认领状态
     */
    private Integer claimStatus;

    /**
     * 任务发起人name
     */
    private String taskAssName;

    /**
     * 流程创建人
     */
    private String procStartUserName;

    /**
     * 任务超期状态
     */
    private Integer taskTimeoutStatus;

    /**
     * 业务类型
     */
    private String category;

    /**
     * 流程回退状态
     * 1：退回任务 2：被退回任务
     */
    private Integer backStatus;

    /*
     *  最后一次计算时间
     * */
    private Date reckonTime;

    /**
     * 操作模式（新增还是更新），用于判断该执行何种逻辑：1新增，2更新
     */
    private int mode;

    /*
    *  flowable 自带任务超期时间
    * */
    private Date flowDueDate;


    /*
    *  操作时间
    * */
    private Date optTime;

    /*
     *  工作日ID
     * */
    private String workId;

    @Override
    public String toString() {
        return "StatisticsTask{" +
                "taskId='" + taskId + '\'' +
                ", taskName='" + taskName + '\'' +
                ", procDefId='" + procDefId + '\'' +
                ", procInsId='" + procInsId + '\'' +
                ", taskAssDepId='" + taskAssDepId + '\'' +
                ", taskAssRoleId='" + taskAssRoleId + '\'' +
                ", taskAssId='" + taskAssId + '\'' +
                ", taskStartDate=" + taskStartDate +
                ", taskDueDays=" + taskDueDays +
                ", taskDueHours=" + taskDueHours +
                ", taskDueDate=" + taskDueDate +
                ", taskEndDate=" + taskEndDate +
                ", taskTimeoutDays=" + taskTimeoutDays +
                ", taskTimeoutHours=" + taskTimeoutHours +
                ", taskStatus=" + taskStatus +
                ", claimStatus=" + claimStatus +
                ", taskAssName='" + taskAssName + '\'' +
                ", procStartUserName='" + procStartUserName + '\'' +
                ", category='" + category + '\'' +
                ", taskTimeoutStatus=" + taskTimeoutStatus +
                '}';
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId == null ? null : taskId.trim();
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getProcDefId() {
        return procDefId;
    }

    public void setProcDefId(String procDefId) {
        this.procDefId = procDefId == null ? null : procDefId.trim();
    }

    public String getProcDefKey() {
        return procDefKey;
    }

    public void setProcDefKey(String procDefKey) {
        this.procDefKey = procDefKey;
    }

    public String getProcInsId() {
        return procInsId;
    }

    public void setProcInsId(String procInsId) {
        this.procInsId = procInsId == null ? null : procInsId.trim();
    }

    public String getTaskAssDepId() {
        return taskAssDepId;
    }

    public void setTaskAssDepId(String taskAssDepId) {
        this.taskAssDepId = taskAssDepId == null ? null : taskAssDepId.trim();
    }

    public String getTaskAssRoleId() {
        return taskAssRoleId;
    }

    public void setTaskAssRoleId(String taskAssRoleId) {
        this.taskAssRoleId = taskAssRoleId == null ? null : taskAssRoleId.trim();
    }

    public String getTaskAssId() {
        return taskAssId;
    }

    public void setTaskAssId(String taskAssId) {
        this.taskAssId = taskAssId == null ? null : taskAssId.trim();
    }

    public Date getTaskStartDate() {
        return taskStartDate;
    }

    public void setTaskStartDate(Date taskStartDate) {
        this.taskStartDate = taskStartDate;
    }

    public Integer getTaskDueDays() {
        return taskDueDays;
    }

    public void setTaskDueDays(Integer taskDueDays) {
        this.taskDueDays = taskDueDays;
    }

    public Integer getTaskDueHours() {
        return taskDueHours;
    }

    public void setTaskDueHours(Integer taskDueHours) {
        this.taskDueHours = taskDueHours;
    }

    public Date getTaskDueDate() {
        return taskDueDate;
    }

    public void setTaskDueDate(Date taskDueDate) {
        this.taskDueDate = taskDueDate;
    }

    public Date getTaskEndDate() {
        return taskEndDate;
    }

    public void setTaskEndDate(Date taskEndDate) {
        this.taskEndDate = taskEndDate;
    }

    public Integer getTaskTimeoutDays() {
        return taskTimeoutDays;
    }

    public void setTaskTimeoutDays(Integer taskTimeoutDays) {
        this.taskTimeoutDays = taskTimeoutDays;
    }

    public Integer getTaskTimeoutHours() {
        return taskTimeoutHours;
    }

    public void setTaskTimeoutHours(Integer taskTimeoutHours) {
        this.taskTimeoutHours = taskTimeoutHours;
    }

    public Integer getTaskStatus() {
        return taskStatus;
    }

    public void setTaskStatus(Integer taskStatus) {
        this.taskStatus = taskStatus;
    }

    public Integer getClaimStatus() {
        return claimStatus;
    }

    public void setClaimStatus(Integer claimStatus) {
        this.claimStatus = claimStatus;
    }


    public String getTaskAssName() {
        return taskAssName;
    }

    public void setTaskAssName(String taskAssName) {
        this.taskAssName = taskAssName;
    }

    public String getProcStartUserName() {
        return procStartUserName;
    }

    public void setProcStartUserName(String procStartUserName) {
        this.procStartUserName = procStartUserName;
    }

    public Integer getTaskTimeoutStatus() {
        return taskTimeoutStatus;
    }

    public void setTaskTimeoutStatus(Integer taskTimeoutStatus) {
        this.taskTimeoutStatus = taskTimeoutStatus;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Integer getBackStatus() {
        return backStatus;
    }

    public void setBackStatus(Integer backStatus) {
        this.backStatus = backStatus;
    }

    public Date getReckonTime() {
        return reckonTime;
    }

    public void setReckonTime(Date reckonTime) {
        this.reckonTime = reckonTime;
    }

    public int getMode() {
        return mode;
    }

    public StatisticsTaskDto setMode(int mode) {
        this.mode = mode;
        return this;
    }

    public Date getFlowDueDate() {
        return flowDueDate;
    }

    public StatisticsTaskDto setFlowDueDate(Date flowDueDate) {
        this.flowDueDate = flowDueDate;
        return this;
    }

    public Date getOptTime() {
        return optTime;
    }

    public StatisticsTaskDto setOptTime(Date optTime) {
        this.optTime = optTime;
        return this;
    }

    public String getWorkId() {
        return workId;
    }

    public void setWorkId(String workId) {
        this.workId = workId;
    }
}