package cn.gtmap.gtc.workflow.clients.define.v1;


import cn.gtmap.gtc.workflow.domain.define.ProcessDefLInkConfigDto;
import cn.gtmap.gtc.workflow.domain.define.StartKeyDto;
import cn.gtmap.gtc.workflow.domain.define.StartRoleDto;
import cn.gtmap.gtc.workflow.domain.define.StartSettingDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 启动的配置的对外接口
 */
@FeignClient("${app.services.bpm-define:bpm-define}")
@RequestMapping("define/v1")
public interface StartUpSettingClient {


    /**
     * 获取流程定义和配置关联列表
     * @return
     */
    @RequestMapping(
            value = {"/startUp-config/processDef-list"},
            method = {RequestMethod.GET}
    )
    Page<ProcessDefLInkConfigDto> queryProcessDefLinkConfig(@RequestParam(value = "name",required = false) String name,
                                                            @RequestParam(value = "category",required = false)String category,Pageable pageable);


    /**
     * 根据名称获取启动配置的列表
     * @param name
     * @param pageable
     * @return
     */
    @RequestMapping(
            value = {"/startUp-config/list"},
            method = {RequestMethod.GET}
    )
    public Page<StartSettingDto> listStartUpSetting(@RequestParam("name") String name, Pageable pageable);


    /**
     * 根据流程定义key获取激活的启动的配置
     * @param businessKey
     */
    @RequestMapping(
            value = {"/startUp-config/condition"},
            method = {RequestMethod.GET}
    )
    public StartSettingDto getStartSettingByBusinessKey(@RequestParam("businessKey") String businessKey);

    /**
     * 获取某个启动设置
     * @param id
     * @return
     */
    @RequestMapping(
            value = {"/startUp-config/{id}"},
            method = {RequestMethod.GET}
    )
    public StartSettingDto getStartSetting(@PathVariable("id") String id);

    /**
     * 新增启动配置
     * @param startSettingDto
     */
    @RequestMapping(
            value = {"/startUp-config"},
            method = {RequestMethod.POST}
    )
    public String addStartSetting(@RequestBody StartSettingDto startSettingDto);

    /**
     * 更新启动配置
     * @param startSettingDto
     */
    @RequestMapping(
            value = {"/startUp-config"},
            method = {RequestMethod.PUT}
    )
    public void updateStartSetting(@RequestBody StartSettingDto startSettingDto);


    /**
     * 删除启动配置
     * @param id
     */
    @RequestMapping(
            value = {"/startUp-config/{id}"},
            method = {RequestMethod.DELETE}
    )
    public void deleteStartSetting(@PathVariable("id") String id);

    /**
     * 保存流程定义和配置项的关联
     * @param startKeyDto
     * @throws Exception
     */
    @RequestMapping(
            value = {"/startUp-config/config-link"},
            method = {RequestMethod.POST}
    )
    public void saveStartUpLink(@RequestBody StartKeyDto startKeyDto);

    /**
     * 根据流程定义key获取流程的关联
     * @param businessKey
     * @return
     * @throws Exception
     */
    @RequestMapping(
            value = {"/startUp-config/role-link"},
            method = {RequestMethod.GET}
    )
    public List<StartRoleDto> getRoleLink(@RequestParam("businessKey") String businessKey);

    /**
     * 保存流程定义和角色关联
     * @param startRoleDtos
     * @throws Exception
     */
    @RequestMapping(
            value = {"/startUp-config/role-link"},
            method = {RequestMethod.POST}
    )
    public void saveRoleLink(@RequestParam("businessKey")String businessKey,@RequestBody List<StartRoleDto> startRoleDtos);
}
