/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.clients.manage;

import cn.gtmap.gtc.workflow.domain.manage.CategoryProcessDto;
import cn.gtmap.gtc.workflow.domain.manage.RuIdentitylink;
import cn.gtmap.gtc.workflow.domain.manage.TaskData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${app.services.bpm-manage:bpm-manage}")
@RequestMapping(value={"manage/v1"})
public interface ProcessTaskClient {
    @GetMapping(value={"/process-tasks/{taskId}"})
    public TaskData getTaskById(@PathVariable(value="taskId") String var1);

    @GetMapping(value={"/process-tasks/process-ins/current"})
    public List<TaskData> processRunningTasks(@RequestParam(value="processInsId") String var1);

    @GetMapping(value={"/process-tasks/process-ins/last"})
    public List<TaskData> processLastTasks(@RequestParam(value="processInsId") String var1);

    @GetMapping(value={"/process-tasks/category-process"})
    public List<CategoryProcessDto> listCategoryProcess(@RequestParam(value="username") String var1);

    @RequestMapping(value={"/process-tasks/{userId}/task-list-addition"}, method={RequestMethod.GET})
    public HashMap<String, Object> taskCreateList(@PathVariable(value="userId") String var1);

    @RequestMapping(value={"/process-tasks/count"}, method={RequestMethod.GET})
    public Integer claimTaskCount(@RequestParam(value="userId", required=false) String var1);

    @RequestMapping(value={"/process-tasks/task-list-unclaimed"}, method={RequestMethod.GET})
    public Page<TaskData> claimTaskList(@RequestParam(value="username", required=false) String var1, @RequestParam(value="category", required=false) String var2, @RequestParam(value="processInstanceName", required=false) String var3, Pageable var4);

    @RequestMapping(value={"/process-tasks/task-list-undoned"}, method={RequestMethod.GET})
    public Page<TaskData> todoTaskList(@RequestParam(value="userId", required=false) String var1, @RequestParam(value="category", required=false) String var2, @RequestParam(value="processInstanceName", required=false) String var3, Pageable var4);

    @RequestMapping(value={"/process-tasks/task-list-finished"}, method={RequestMethod.GET})
    public Page<TaskData> completeTaskList(@RequestParam(value="userId") String var1, @RequestParam(value="category") String var2, @RequestParam(value="processInstanceName") String var3, Pageable var4);

    @RequestMapping(value={"/process-tasks/{taskId}/task-idm"}, method={RequestMethod.GET})
    public List<RuIdentitylink> getIdentityByTaskId(@PathVariable(value="taskId") String var1) throws Exception;

    @RequestMapping(value={"/process-tasks/{taskId}/cancel-claim"}, method={RequestMethod.GET})
    public boolean cancelTaskClaimBack(@PathVariable(value="taskId") String var1);

    @Deprecated
    @RequestMapping(value={"/process-tasks/{taskId}/fallback"}, method={RequestMethod.GET})
    public String taskRecaption(@PathVariable(value="taskId") String var1);

    @RequestMapping(value={"/processInstanceManage"}, method={RequestMethod.GET})
    public Object createNativeProcessInstanceQuery();

    @RequestMapping(value={"/task-variables/{taskId}"}, method={RequestMethod.POST})
    public void addTaskVariables(@PathVariable(value="taskId") String var1, @RequestParam(value="isLocal") Integer var2, @RequestBody Map<String, Object> var3);

    @RequestMapping(value={"/task-variables/{taskId}"}, method={RequestMethod.GET})
    public Map<String, Object> getTaskVariables(@PathVariable(value="taskId") String var1, @RequestParam(value="isLocal") Integer var2);
}

