/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.clients.define.v1;

import cn.gtmap.gtc.workflow.domain.common.BaseRestActionRepresentation;
import cn.gtmap.gtc.workflow.domain.common.ResultListData;
import cn.gtmap.gtc.workflow.domain.define.rest.ModelInformationView;
import cn.gtmap.gtc.workflow.domain.define.rest.ModelRepresentationView;
import cn.gtmap.gtc.workflow.domain.define.rest.ReviveModelResultRepresentationView;
import cn.gtmap.gtc.workflow.domain.define.rest.ValidationErrorView;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@FeignClient(value="${app.services.bpm-define:bpm-define}")
@RequestMapping(value={"/define/v1"})
public interface ModelerClient {
    @RequestMapping(value={"/models/{processModelId}/bpmn20"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> getProcessModelBpmn20Xml(@PathVariable(value="processModelId") String var1);

    @RequestMapping(value={"/models/{processModelId}/history/{processModelHistoryId}/bpmn20"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> getHistoricProcessModelBpmn20Xml(@PathVariable(value="processModelId") String var1, @PathVariable(value="processModelHistoryId") String var2);

    @RequestMapping(value={"/models/{modelId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelRepresentationView getModel(@PathVariable(value="modelId") String var1);

    @RequestMapping(value={"/models/{modelId}/thumbnail"}, method={RequestMethod.GET}, produces={"image/png"})
    public ResponseEntity<byte[]> getModelThumbnail(@PathVariable(value="modelId") String var1);

    @RequestMapping(value={"/models/{modelId}"}, method={RequestMethod.PUT})
    public ModelRepresentationView updateModel(@PathVariable(value="modelId") String var1, @RequestBody ModelRepresentationView var2);

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/models/{modelId}"}, method={RequestMethod.DELETE})
    public void deleteModel(@PathVariable(value="modelId") String var1);

    @RequestMapping(value={"/models/{modelId}/json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ObjectNode getModelJSON(@PathVariable(value="modelId") String var1);

    @RequestMapping(value={"/models/{modelId}/json"}, method={RequestMethod.POST})
    public ModelRepresentationView saveModel(@PathVariable(value="modelId") String var1, @RequestBody MultiValueMap<String, String> var2, @RequestParam(value="userId") String var3);

    @RequestMapping(value={"/models/{modelId}/newversion"}, method={RequestMethod.POST})
    public ModelRepresentationView importNewVersion(@PathVariable(value="modelId") String var1, @RequestParam(value="file") MultipartFile var2);

    @RequestMapping(value={"/models/{modelId}/history"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultListData getModelHistoryCollection(@PathVariable(value="modelId") String var1, @RequestParam(value="includeLatestVersion", required=false) Boolean var2);

    @RequestMapping(value={"/models/{modelId}/history/{modelHistoryId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelRepresentationView getProcessModelHistory(@PathVariable(value="modelId") String var1, @PathVariable(value="modelHistoryId") String var2);

    @RequestMapping(value={"/models/{modelId}/history/{modelHistoryId}/{userId}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ReviveModelResultRepresentationView executeProcessModelHistoryAction(@PathVariable(value="modelId") String var1, @PathVariable(value="modelHistoryId") String var2, @PathVariable(value="userId") String var3, @RequestBody(required=true) BaseRestActionRepresentation var4);

    @RequestMapping(value={"/models/{modelId}/parent-relations"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<ModelInformationView> getModelRelations(@PathVariable(value="modelId") String var1);

    @RequestMapping(value={"/models/upload"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"}, consumes={"multipart/form-data"})
    public ModelRepresentationView importProcessModel(@RequestParam(value="userId") String var1, @RequestPart(value="file") MultipartFile var2);

    @RequestMapping(value={"/models/upload/text"}, produces={"application/json"})
    public String importProcessModelText(@RequestParam(value="userId") String var1, @RequestPart(value="file") MultipartFile var2);

    @RequestMapping(value={"/models"}, method={RequestMethod.POST}, produces={"application/json"})
    public ModelRepresentationView createModel(@RequestParam(value="userId") String var1, @RequestBody ModelRepresentationView var2);

    @RequestMapping(value={"/models/validate"}, method={RequestMethod.POST}, consumes={"application/json"})
    public List<ValidationErrorView> validate(@RequestBody JsonNode var1);

    @RequestMapping(value={"/models/{modelId}/duplicates"}, method={RequestMethod.POST}, produces={"application/json"})
    public ModelRepresentationView duplicateModel(@PathVariable(value="modelId") String var1, @RequestParam(value="userId") String var2, @RequestBody ModelRepresentationView var3);
}

