/**
 * Gtmap 公共方法
 * @author 杨红杰
 * @date 2019-04-17
 */

/**
 * jquery设置cors跨域，解决ie低版本浏览器获取获取ajax数据失败的问题
 * @type {boolean}
 */
$.support.cors = true;

/**
 * 重写toFixed方法，使其“四舍五入”
 * @param s
 * @returns {string}
 */
Number.prototype.toFixed = function (s) {
    var tmp = 0.5;
    if (this < 0) {
        tmp = -0.5;
    }
    var changenum = (parseInt(this * Math.pow(10, s) + tmp) / Math.pow(10, s)).toString();
    var index = changenum.indexOf(".");
    if (index < 0 && s > 0) {
        changenum += ".";
        for (i = 0; i < s; i++) {
            changenum += "0";
        }
    } else {
        index = changenum.length - index;
        for (i = 0; i < (s - index) + 1; i++) {
            changenum += "0";
        }
    }
    return changenum;
};

/**
 * 数组遍历
 */
if (!Array.prototype.forEach) {
    Array.prototype.forEach = function (callback, thisArg) {
        var T, k;
        if (this === null) {
            throw new TypeError("this is null or not defined")
        }
        var O = Object(this);
        var len = O.length >>> 0;
        if (typeof callback !== "function") {
            throw new TypeError(callback + " is not a function");
        }
        if (arguments.length > 1) {
            T = thisArg;
        }
        k = 0;
        while (k < len) {
            var kValue;
            if (k in O) {
                kValue = O[k];
                callback.call(T, kValue, k, O);
            }
            k++;
        }
    }
}

/**
 * 对Date的扩展，将 Date 转化为指定格式的String
 * 月(M)、日(d)、小时(h)、分(m)、秒(s)、季度(q) 可以用 1-2 个占位符，
 * 年(y)可以用 1-4 个占位符，毫秒(S)只能用 1 个占位符(是 1-3 位的数字)
 * 例子：
 * (new Date()).Format("yyyy-MM-dd hh:mm:ss.S") ==> 2006-07-02 08:09:04.423
 * (new Date()).Format("yyyy-M-d h:m:s.S")      ==> 2006-7-2 8:9:4.18
 * @param fmt
 * @returns {*}
 * @constructor
 */
Date.prototype.Format = function (fmt) {
    var o = {
        "M+": this.getMonth() + 1,                       //月份
        "d+": this.getDate(),                            //日
        "h+": this.getHours(),                           //小时
        "m+": this.getMinutes(),                         //分
        "s+": this.getSeconds(),                         //秒
        "q+": Math.floor((this.getMonth() + 3) / 3), //季度
        "S": this.getMilliseconds()                      //毫秒
    };
    if (/(y+)/.test(fmt)) {
        fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    }
    for (var k in o) {
        if (new RegExp("(" + k + ")").test(fmt)) {
            fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
        }
    }
    return fmt;
}

/**
 * 将字符串中的所有指定内容替换掉
 * @param reallyDo 第一个参数可以是要被替换的字符串或者是一个匹配要被替换字符串的正则表达式
 * @param replaceWith 第二个参数规定使用哪些字符串进行替换
 * @param ignoreCase 第三个参数是一个布尔值，用来规定是否忽略字符大小写，如果是true则忽略，否则不忽略
 * 例子：
 * var str="蚂蚁部落欢迎您，希望大家在蚂蚁部落能够获得想要的东西";
 * str = str.replaceAll("蚂蚁部落","本站",true);
 * ==> 本站欢迎您，希望大家在本站能够获得想要的东西
 * @returns {string}
 */
String.prototype.replaceAll = function (reallyDo, replaceWith, ignoreCase) {
    if (!RegExp.prototype.isPrototypeOf(reallyDo)) {
        return this.replace(new RegExp(reallyDo, (ignoreCase ? "gi" : "g")), replaceWith);
    }
    return this.replace(reallyDo, replaceWith);
}

/**
 * 判断当前字符串是否是以另外一个给定的子字符串“结尾”的，根据判断结果返回 true 或 false
 * @param s
 * @returns {boolean}
 */
String.prototype.endWith = function (s) {
    if (s == null || s == "" || this.length == 0 || s.length > this.length)
        return false;
    if (this.substring(this.length - s.length) == s)
        return true;
    return false;
}

/**
 * 判断当前字符串是否是以另外一个给定的子字符串“开头”的，根据判断结果返回 true 或 false
 * @param s
 * @returns {boolean}
 */
String.prototype.startWith = function (s) {
    if (s == null || s == "" || this.length == 0 || s.length > this.length)
        return false;
    if (this.substr(0, s.length) == s)
        return true;
    return false;
}

;(function ($) {
    /**
     * 将form表单转化为Json
     */
    $.fn.serializeJson = function () {
        var serializeObj = {};
        var array = this.serializeArray();
        var str = this.serialize();
        $(array).each(function () {
            if (serializeObj[this.name]) {
                if ($.isArray(serializeObj[this.name])) {
                    serializeObj[this.name].push(this.value);
                } else {
                    serializeObj[this.name] = [serializeObj[this.name], this.value];
                }
            } else {
                serializeObj[this.name] = this.value;
            }
        });
        return serializeObj;
    };
    /**
     * 将form表单转化为Json字符串
     */
    $.fn.serializeJsonStr = function () {
        return JSON.stringify(this.serializeJson());
    };
})($);

/**
 * 验证是否为数字
 * @param value
 * @returns {boolean}
 */
function isNumber(value) {
    if (value) {
        if (/^\-?\d*\.?\d*$/.test(value)) {
            return true;
        }
    }
    return false;
}

/**
 * 格式化数字
 * @param value
 * @param num 保留小数位，当要整数时该值可以不传
 * @param sfbl 是否补0，不需要补0可以不传
 * @returns
 */
function formatNum(value, num, sfbl) {
    if ($.trim(value) == "" || isNaN(value)) {
        return 0;
    }

    var n = 0;
    if ($.trim(num) != "" && !isNaN(num) && parseInt(num) > 0 && parseInt(num) <= 20) {
        n = parseInt(num);
    }

    var v = parseFloat(value);
    v = v.toFixed(n);

    if ($.trim(sfbl) != "true") {
        return parseFloat(v);
    }
    return v;
}

/**
 * rmb小写转大写
 * @param num
 * @returns {*}
 */
function changeDx(num) {
    if (!isNumber(num)) {
        return num;
    }
    var strOutput = "", strUnit = '仟佰拾亿仟佰拾万仟佰拾元角分';
    num = (num * 100).toString();
    var intPos = num.indexOf('.');
    if (intPos >= 0) {
        num = num.substring(0, intPos) + num.substr(intPos + 1, 2);
    }
    strUnit = strUnit.substr(strUnit.length - num.length);
    for (var i = 0; i < num.length; i++) {
        strOutput += '零壹贰叁肆伍陆柒捌玖'.substr(num.substr(i, 1), 1) + strUnit.substr(i, 1);
    }
    return strOutput.replace(/零角零分$/, '整').replace(/零[仟佰拾]/g, '零').replace(/零{2,}/g, '零').replace(/零([亿|万])/g, '$1').replace(/零+元/, '元').replace(/亿零{0,3}万/, '亿').replace(/^元/, "零元");
}

/**
 * rmb小写转大写
 * @param num 单位为万元
 * @returns {*}
 */
function changeDxWy(num) {
    if (!isNumber(num)) {
        return num;
    }
    var strOutput = "", strUnit = '仟佰拾亿仟佰拾万仟佰拾元角分';
    num = (num * 100 * 10000).toString();
    var intPos = num.indexOf('.');
    if (intPos >= 0) {
        num = num.substring(0, intPos) + num.substr(intPos + 1, 2);
    }
    strUnit = strUnit.substr(strUnit.length - num.length);
    for (var i = 0; i < num.length; i++) {
        strOutput += '零壹贰叁肆伍陆柒捌玖'.substr(num.substr(i, 1), 1) + strUnit.substr(i, 1);
    }
    return strOutput.replace(/零角零分$/, '整').replace(/零[仟佰拾]/g, '零').replace(/零{2,}/g, '零').replace(/零([亿|万])/g, '$1').replace(/零+元/, '元').replace(/亿零{0,3}万/, '亿').replace(/^元/, "零元");
}

/**
 * 获取url地址参数
 * @returns {Array}
 */
function getUrlVars() {
    var vars = [], hash;
    var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
    for (var i = 0; i < hashes.length; i++) {
        hash = hashes[i].split('=');
        vars.push(hash[0]);
        vars[hash[0]] = hash[1];
    }
    return vars;
}

/**
 * 获取url地址参数值
 * @param name
 * @returns {*}
 */
function getQueryString(name) {
    var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
    var r = location.search.substr(1).match(reg);
    if (r != null) return unescape(r[2]);
    return null;
}

/**
 * 合并表格中的单元格
 * @param $rows 表格中的所有行对象
 * @param startIndex 从第几列开始处理
 * @param total 需要处理的列数
 * 调用方式：
 groupTable($('#test tr:has(td)'), 0, 4);
 $('#test .deleted').remove();
 *  引用网址：http://techbrij.com/html-table-row-grouping-jquery
 */
function groupTableTdInput($rows, startIndex, total) {
    if (total === 0) {
        return;
    }
    var i, currentIndex = startIndex, count = 1, lst = [];
    var tds = $rows.find('td:eq(' + currentIndex + ')');//获取当前列号的所有列集合（该列的所有td）
    var ctrl = $(tds[0]);//获取列集合的第一个列td（第一次执行则是第一个td数据）
    lst.push($rows[0]);//将该td所在行放入数组（第一次执行则是第一行数据）
    //遍历该列集合
    for (i = 1; i <= tds.length; i++) {
        if (!ctrl.html()) {
            ctrl.html('<label>&nbsp</label>');
        }
        if (!$(tds[i]).html()) {
            $(tds[i]).html('<label>&nbsp</label>');
        }
        if (ctrl.html() && ctrl.html() == $(tds[i]).html()) {
            //如果上一个td内容等于当前td内容，则count加1，
            //且当前td增加deleted样式进行标识（用于后期删除使用）
            //将该td所在行放入数组
            count++;
            $(tds[i]).addClass('deleted');
            lst.push($rows[i]);
        } else {
            //如果上一个td内容不等于当前td内容，则进行如下判断和操作：
            //如果count大于1，则表示有相同的td需要合并，
            //对该td的rowspan赋值，值为需要合并的行数
            //此时递归调用该方法，对之前合并单元格所涉及到的行数据进行处理（用于处理后面列的td合并）
            //处理方式是当前列后面一列进行操作，total减少一个（当前操作的列）直至total为0
            if (count > 1) {
                ctrl.attr('rowspan', count);
                //ctrl.css("vertical-align","middle");
                //ctrl.css("text-align","center");
                common.groupTableTdInput($(lst), startIndex + 1, total - 1)
            }
            //将count初始化为1
            //数据初始为空
            //td初始化为当前td
            //将该td所在行放入数组
            count = 1;
            lst = [];
            ctrl = $(tds[i]);
            lst.push($rows[i]);
        }
        //$(tds[i]).css("text-align","center");
        //$(tds[i]).css("vertical-align","middle");
    }
}

/**
 * 下载的公共方法
 * @param url
 */
function downloadURL(url) {
    var hiddenIFrameID = 'hiddenDownloader';
    var iframe = document.getElementById(hiddenIFrameID);
    if (iframe === null) {
        iframe = document.createElement('iframe');
        iframe.id = hiddenIFrameID;
        iframe.style.display = 'none';
        document.body.appendChild(iframe);
    }
    iframe.src = url;
}

/**
 * 获取父页面url
 * @returns {*}
 */
function getParentUrl() {
    var url = null;
    if (parent !== window) {
        try {
            url = parent.location.href;
        } catch (e) {
            url = document.referrer;
        }
    }
    return url;
}

/**
 * 获取url中的域名或ip
 * @param url
 * @returns {*}
 */
function getDomainUrl(url) {
    if ($.trim(url) == "") {
        return url;
    }
    var tmp = url.split("/");
    return tmp[0] + "//" + tmp[2];
}

/**
 * 字典转换
 * @param key 要转换的值
 * @param name 下拉框控件 id 或 name
 * @returns {*}
 */
function convert(key, name) {
    if (key == null || key == undefined || $.trim(key) == "") {
        return "";
    }
    var temp = $("#" + name + ",[name='" + name + "']");
    if (temp.length > 0) {
        var len = temp[0].options.length;
        for (var i = 0; i < len; i++) {
            if (temp[0].options[i].value == key) {
                return temp[0].options[i].text;
            }
        }
    }
    return key;
}

/**
 *  post方式传值
 * @param url
 * @param params
 */
function doPost(url, params) {
    var tempForm = document.createElement("form");
    tempForm.action = url;
    tempForm.target = "_blank";
    tempForm.method = "post";
    for (var x in params) {
        var hideInput = document.createElement("input");
        hideInput.type = "hidden";
        hideInput.name = x;
        hideInput.value = params[x];
        tempForm.appendChild(hideInput);
    }
    document.body.appendChild(tempForm);
    tempForm.submit();
    tempForm.remove();
}

/**
 * 打开文件中心
 * @param proid
 * @param readOnly 是否只读，默认true
 */
function openFileCenter(proid, readOnly) {
    if ($.trim(proid) != "") {
        readOnly = $.trim(readOnly) == "" ? true : readOnly;
        platformUrl = typeof platformUrl != "undefined" ? platformUrl : "/platform";
        var url = platformUrl + "/fc.action?readOnly=" + readOnly + "&proid=" + proid;
        layerOpen(url, null, null, "<i class='icon iconfont icon-folder-open'></i> 文件中心");
    }
}

/**
 * 打开新窗口
 * @param url
 * @param width
 * @param height
 * @param resizable
 */
function openUrl(url, width, height, resizable) {
    if (url) {
        var w_width = screen.availWidth - 14;
        var w_height = screen.availHeight - 66;
        var left = 0;
        var top = 0;
        if (width) {
            w_width = width;
            left = (screen.availWidth - w_width) / 2;
        }
        if (height) {
            w_height = height;
            top = (screen.availHeight - w_height) / 2;
        }
        if (!resizable) {
            resizable = "yes";
        }
        window.open(url, "_blank", "left=" + left + ",top=" + top + ",height=" + w_height + ",width=" + w_width + ",resizable=" + resizable + ",scrollbars=yes");
    }
}

/**
 * 用于layui table插入行
 * @param layId
 * @returns {Array}
 */
function getLayuiTableData(layId) {
    var data = [];
    $.each($("div[lay-id='" + layId + "'] .layui-table-body tr"), function () {
        var field = {};
        $.each($(this).find("*[field]"), function () {
            field[$(this).attr("field")] = $(this).val();
        });
        data.push(field);
    });
    return data;
}

/**
 * 询问框
 * @param msg 消息
 * @param callback 确认回调事件
 * @param cancel 取消回调事件
 */
function layerConfirm(msg, callback, cancel) {
    msg = $.trim(msg) == "" ? "　" : msg;
    layui.use("layer", function () {
        var layer = layui.layer;
        layer.confirm(msg, {icon: 3, title: '提示'}, function (index) {
            if (typeof callback == "function") {
                callback();
            }
            layer.close(index);
        }, function () {
            if (typeof cancel == "function") {
                cancel();
            }
        });
    });
}

/**
 * 弹窗
 * @param url 地址
 * @param width 宽度，默认90%
 * @param height 高度，默认90%
 * @param title 标题
 * @param maxmin 默认true，最大化按钮
 */
function layerOpen(url, width, height, title, maxmin) {
    width = !width ? $(window).width() * 0.9 : width;
    height = !height ? $(window).height() * 0.9 : height;
    title = !title ? '　' : title;
    maxmin = $.trim(maxmin) == "" ? true : maxmin;
    layui.use("layer", function () {
        var layer = layui.layer;
        layer.open({
            type: 2,
            title: title,
            fix: false,
            shadeClose: true,
            maxmin: maxmin,
            area: [width + 'px', height + 'px'],
            content: url
        });
    });
}

/**
 * layer 弹出窗口关闭
 */
function layerClose() {
    parent.layer.close(parent.layer.getFrameIndex(window.name));
}

/**
 * 消息框
 * @param msg 支持字符串和json
 * @param reload 是否刷新
 * @param func 回调函数
 * @param icon 图标
 */
function layerAlert(msg, reload, func, icon) {
    var _msg = "　";
    var _icon = 7;
    if ("string" != typeof msg) {
        if (msg.result == false) {
            _icon = 2;
        } else {
            _icon = 1;
        }
        if (msg.msg) {
            _msg = msg.msg;
        }
    } else {
        _msg = msg;
    }
    if ($.trim(icon) != "" && formatNum(icon) >= 0 && formatNum(icon) <= 7) {
        _icon = formatNum(icon);
    }
    layui.use("layer", function () {
        var layer = layui.layer;
        layer.alert(_msg, {icon: _icon});
        $(".layui-layer-close").remove();
        if (reload == true) {
            $(".layui-layer-btn0").click(function () {
                location.reload();
            });
        } else {
            $(".layui-layer-btn0").click(function () {
                if ($.trim(func) != "") {
                    try {
                        eval(func);
                    } catch (e) {
                    }
                }
            });
        }
    });
}

/**
 * 信息提示
 * @param msg
 * @param icon
 */
function layerMsg(msg, icon) {
    layui.use("layer", function () {
        var layer = layui.layer;
        if (icon) {
            layer.msg(msg, {icon: icon});
        } else {
            layer.msg(msg);
        }
    });
}

/**
 * 帆软编码转换
 * @param text
 * @returns {string}
 */
function cjkEncode(text) {
    if (text == null) {
        return "";
    }
    var newText = "";
    for (var i = 0; i < text.length; i++) {
        var code = text.charCodeAt(i);
        if (code >= 128 || code == 91 || code == 93) {//91 is "[", 93 is "]".
            newText += "[" + code.toString(16) + "]";
        } else {
            newText += text.charAt(i);
        }
    }
    return newText;
}

/**
 * 帆软打印
 * 如果要使用帆软打印功能，需要在帆软public.js中添加如下脚本：
 * goInitPrint();
 * // 初始化打印，url中添加参数initprint=true
 * function goInitPrint() {
 *      if (getQueryString("initprint") == "true") {
 *          var config = {url: location.href, isPopUp: false};
 *          setTimeout(function(){FR.doURLFlashPrint(config);}, 50);
 *      }
 *  }
 *  // 获取url参数
 * function getQueryString(name) {
 *    var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
 *    var r = location.search.substr(1).match(reg);
 *    if(r != null) return unescape(r[2]);
 *    return null;
 *  }
 * @param path
 */
function frPrint(path) {
    if ($.trim(path) != "") {
        var id = "fr_iframe";
        var iframe = $("#" + id);
        if (iframe.length === 0) {
            iframe = document.createElement("iframe");
            iframe.id = id;
            iframe.width = 0;
            iframe.height = 0;
            reportUrl = typeof reportUrl != "undefined" ? reportUrl : "/report";
            iframe.src = reportUrl + "/ReportServer?reportlet=" + path + "&initprint=true";
            document.body.appendChild(iframe);
        } else {
            iframe.attr("src", iframe.attr("src"));
        }
    }
}
/**
 * 帆软导出word
 * @param path
 */
function frExportWord(path) {
    if ($.trim(path) != "") {
        reportUrl = typeof reportUrl != "undefined" ? reportUrl : "/report";
        location.href = reportUrl + "/ReportServer?reportlet=" + path + "&format=word";
    }
}
/**
 * 帆软导出excel
 * @param path
 */
function frExportExcel(path) {
    if ($.trim(path) != "") {
        reportUrl = typeof reportUrl != "undefined" ? reportUrl : "/report";
        location.href = reportUrl + "/ReportServer?reportlet=" + path + "&format=excel&extype=simple";
    }
}

/**
 * 给表格单元格添加提示
 */
function addTitle() {
    $(".layui-table .layui-table-cell").each(function () {
        var reg = new RegExp("<.+>");
        if ($(this).html().match(reg) === null) {
            $(this).attr("title", $(this).html());
        }
    });
}

/**
 * 具有该样式的控件只能输入数字
 */
function checkNumber() {
    $(".digits,.number0").keyup(function () {
        $(this).val($(this).val().replace(/[^\d]/g, ''));
    });
    $(".digits,.number0").blur(function () {
        $(this).val($(this).val().replace(/[^\d]/g, ''));
    });
    $(".number,.number2,.number4,.number5").keyup(function () {
        $(this).val($(this).val().replace(/[^\d.]/g, ''));
    });
    $(".number,.number2,.number4,.number5").blur(function () {
        $(this).val($(this).val().replace(/[^\d.]/g, ''));
    });
}

/**
 * 0显示为空
 */
function clearZero() {

}

/**
 * 给查询表单添加事件，当输入框回车或者下拉框选择后进行查询操作
 */
function addSearchEvent() {
    $("#gtmapTableForm,.layui-form").bind("keypress", function (e) {
        var keynum = window.event ? e.keyCode : e.which;
        if (keynum == 13) {
            e.preventDefault();
            $("#gtmapTableForm,.layui-form").find("#search,.fa-search").click();
        }
    });
    $("#gtmapTableForm dd,.layui-form dd").click(function () {
        $("#gtmapTableForm,.layui-form").find("#search,.fa-search").click();
    });
}

/**
 * 提示信息
 * @type {{QXZ: string, CZCG: string, CZSB: string, QRCZ: string}}
 */
var CONST_MSG = {
    CZCG: '操作成功！',
    CZSB: '操作失败！',
    QXZ: '请选择！',
    QRCZ: '确认该操作吗？'
};

$(function () {
    gtInit();

    $(window).resize(function () {
        gtInit();
    });

    setTimeout(function () {
        // 初始化日期控件
        layui.use("laydate", function () {
            var laydate = layui.laydate;
            $(".layui-date").each(function () {
                laydate.render({
                    elem: this
                });
            });
            $(".layui-datetime").each(function () {
                laydate.render({
                    elem: this,
                    type: 'datetime'
                });
            });
        });

        checkNumber();
        clearZero();
        addSearchEvent();
    }, 500);
});

/**
 * 页面初始化
 */
function gtInit() {
    var otherHeight = 73;
    // 设置内容部分最小高度
    $(".gt-content,.gt-min-h").css("min-height", $(window).height() - otherHeight);

    // 设置标题宽度
    $(".gt-head").removeAttr("style");
    if ($(".gt-head").width() > $(window).width()) {
        $(".gt-head").width($(window).width() - 50);
    }
}