package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.ModuleDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/7/26
 * @description
 */

@FeignClient(name = "account")
@RequestMapping("/account/rest/v1/modules")
public interface ModuleManagerClient {

    /**
     * @param  moduleDto 模块信息
     * @return
     * @description 添加模块
     */
    @PostMapping
    ModuleDto createModule(@RequestBody ModuleDto moduleDto);

    /**
     * @param  moduleDto 模块信息
     * @return
     * @description 更新模块
     */
    @PutMapping("/update")
    ModuleDto updateModule(@RequestBody ModuleDto moduleDto);

    /**
     * @param  inquirer 模块信息
     * @param  clientId 应用编码
     * @return
     * @description 查询操作人可操作的模块列表
     */
    @GetMapping("/operation-modules")
    List<ModuleDto> listOptModules(@RequestParam(name = "inquirer") String inquirer, @RequestParam(name = "clientId") String clientId);

    /**
     * @param  id 模块id
     * @return
     * @description 删除模块
     * */
    @DeleteMapping("/{id}")
    void deleteModule(@PathVariable(name = "id") String id);

    /**
     * @param  id 模块id
     * @return
     * @description 根据ID查找模块
     */
    @GetMapping("/{id}")
    ModuleDto getModuleById(@PathVariable(name = "id") String id);

    /**
     * @param  id 模块id
     * @param  code 编码
     * @return
     * @description 验证编码唯一性
     */
    @GetMapping("/{code}/code-only")
    boolean validOnlyCode(@RequestParam(name = "id", required = false) String id, @PathVariable(name = "code") String code);

    /**
     * @param  clientId 应用编码
     * @return
     * @description 查找根模块
     */
    @GetMapping("/root")
    public List<ModuleDto> getRootModules(@RequestParam(name = "clientId", required = false) String clientId);

    /**
     * @param  id 模块id
     * @return
     * @description 获取子模块列表
     */
    @GetMapping("/{id}/junior")
    List<ModuleDto> findJuniorModules(@PathVariable("id") String id);

    /**
     * @param
     * @return
     * @description 获取模块类型列表
     */
    @GetMapping("/type")
    List<ModuleDto> findModuleTypes();

    /**
     * 根据角色列表，查询分级权限模块
     *
     * @param clientId   应用ID
     * @param moduleType 模块类型
     * @param roleIds    角色id列表，用","隔开
     * @return 模块列表
     */
    @PostMapping("/role-grading-modules")
    List<ModuleDto> listRoleGradingModules(@RequestParam(name = "clientId", required = false) String clientId,
                                           @RequestParam(name = "moduleType",required = false) String moduleType,
                                           @RequestBody List<String> roleIds);
}
