package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.LoginModelDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhujunjie
 * @version 1.0, 2018/11/19 16:51
 * @description
 */

@FeignClient(name = "account")
@RequestMapping("/account/rest/v1/login-models")
public interface LoginModelManagerClient {

    /**
     * @param  loginModelDto 登陆配置
     * @return
     * @description 创建系统登陆配置
     */
    @PostMapping
    LoginModelDto createConfigure(@RequestBody LoginModelDto loginModelDto);

    /**
     * @param  loginModelDto 登陆配置
     * @return
     * @description 更新系统登陆配置
     */
    @PutMapping
    LoginModelDto updateConfigure(@RequestBody LoginModelDto loginModelDto);

    /**
     * @param  code 登陆配置编码
     * @return
     * @description 根据编码查询系统配置
     */
    @GetMapping("/code")
    LoginModelDto findLoginModelByCode(@RequestParam(name = "code") String code);

    /**
     * @param  id 主键
     * @return
     * @description 根据ID查询页面模型
     */
    @GetMapping("/{id}")
    LoginModelDto findLoginModel(@PathVariable(name = "id") String id);

    /**
     * @param  id 配置id
     * @return
     * @description 删除登陆模型
     */
    @DeleteMapping("/{id}")
    boolean deleteLoginModel(@PathVariable(name = "id") String id);


    /**
     * @param  code 编码
     * @return
     * @description 检查编码是否存在
     */
    @DeleteMapping("/code/exist")
    boolean checkCodeExist(@RequestParam(name = "code") String code);

    /**
     * @param  desc 配置描述
     * @param  code 配置编码
     * @return
     * @description 分页查询
     */
    @GetMapping("/page")
    Page<LoginModelDto> listLoginModels(Pageable pageable, @RequestParam(name = "code", required = false) String code, @RequestParam(name = "desc", required = false) String desc);

    @GetMapping("/list")
    public List<LoginModelDto> list(@RequestParam(name = "code", required = false) String code, @RequestParam(name = "desc", required = false) String desc);
}
