package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.ElementConfDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/12/28
 * @description
 */

@FeignClient(name = "account")
@RequestMapping("/account/rest/v1/elements")
public interface ElementClient {

    /**
     * @param  moduleCode 模块编码
     * @param  code 元素编码
     * @param  description 描述
     * @return
     * @description 列表查询页面元素
     */
    @GetMapping("/list")
    List<ElementConfDto> list(@RequestParam(name = "moduleCode") String moduleCode,
                                     @RequestParam(name = "code", required = false) String code,
                                     @RequestParam(name = "description", required = false) String description);


    /**
     * @param  id 描述
     * @return
     * @description 查询
     */
    @GetMapping
    ElementConfDto findById(@RequestParam(name = "id") String id);

    /**
     * @param  moduleCode 模块编码
     * @param code 元素编码
     * @return
     * @description 通过模块查询
     */
    @GetMapping("/module")
    ElementConfDto findByModuleCode(@RequestParam(name = "moduleCode") String moduleCode,
                                           @RequestParam(name = "code") String code);

    /**
     * @param  elementConfDto 页面元素
     * @return
     * @description 创建/修改
     */
    @PostMapping
    ElementConfDto save(@RequestBody ElementConfDto elementConfDto);

    /**
     * @param  ids 页面元素Id逗号间隔
     * @return
     * @description 删除
     */
    @DeleteMapping
    void delete(@RequestParam(name = "ids") String ids);


    /**
     * @param  moduleCode 页面模块编码
     * @param  username 用户名
     * @return
     * @description 权限查询
     */
    @GetMapping("/authority")
    Map<String, String> getAuthorities(@RequestParam(name = "username") String username, @RequestParam(name = "moduleCode") String moduleCode);
}
