package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.DataAccessCfgDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/8/27
 * @description
 */

@FeignClient(name = "account")
@RequestMapping(value = "/account/rest/v1/data/access")
public interface DataAccessCfgClient {

    @GetMapping
    Page<DataAccessCfgDto> listDataAccessCfg(Pageable pageable,
                                                    @RequestParam(name = "appName",required = false) String appName,
                                                    @RequestParam(name = "accessType",required = false) String accessType,
                                                    @RequestParam(name = "description",required = false) String description);
    @DeleteMapping("/{id}")
    Boolean deleteDataAccessCfg(@PathVariable("id") String id);



    @PostMapping
    DataAccessCfgDto save(@RequestBody DataAccessCfgDto dto);

    @GetMapping("/{id}")
    DataAccessCfgDto getDataAccessConfigDetail(@PathVariable("id") String id);

    @GetMapping("/all")
    List<DataAccessCfgDto> getAllDataAccessConfig();
}
