/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.AuthorityDto;
import cn.gtmap.gtc.sso.domain.dto.BaseResultDto;
import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import cn.gtmap.gtc.sso.domain.dto.RoleDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.sso.domain.dto.UserLeaveDto;
import cn.gtmap.gtc.sso.domain.dto.UserStatusDto;
import java.util.List;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="account")
@RequestMapping(value={"/account/rest/v1/users"})
public interface UserManagerClient {
    @GetMapping(value={"/list"})
    public Page<UserDto> listUsers(@RequestParam(name="username", required=false) String var1, @RequestParam(name="alias", required=false) String var2, @RequestParam(name="enabled", required=false) Integer var3, Pageable var4);

    @GetMapping(value={"/all"})
    public List<UserDto> allUsers(@RequestParam(name="username", required=false) String var1, @RequestParam(name="alias", required=false) String var2, @RequestParam(name="enabled", required=false) Integer var3);

    @GetMapping(value={"/grading-users"})
    public Page<UserDto> listGradeUsers(Pageable var1, @RequestParam(name="inquirer") String var2, @RequestParam(name="username", required=false) String var3, @RequestParam(name="alias", required=false) String var4, @RequestParam(name="enabled", required=false) Integer var5);

    @GetMapping(value={"/grading-org-users"})
    public Page<UserDto> listGradingOrgUsers(Pageable var1, @RequestParam(name="inquirer") String var2, @RequestParam(name="orgId", required=false) String var3, @RequestParam(name="username", required=false) String var4, @RequestParam(name="alias", required=false) String var5, @RequestParam(name="enabled", required=false) Integer var6, @RequestParam(name="mobile", required=false) String var7);

    @GetMapping(value={"/grading-org-user-online"})
    public Page<UserStatusDto> listGradingOrgUserOnline(Pageable var1, @RequestParam(name="inquirer") String var2, @RequestParam(name="orgId", required=false) String var3, @RequestParam(name="username", required=false) String var4, @RequestParam(name="alias", required=false) String var5, @RequestParam(name="enabled", required=false) Integer var6);

    @PostMapping
    public UserDto createNewUser(@RequestBody UserDto var1);

    @PostMapping(value={"/import"})
    public BaseResultDto importUsers(@RequestBody List<UserDto> var1);

    @PutMapping(value={"/{id}"})
    public UserDto updateUser(@PathVariable(value="id") String var1, @RequestBody UserDto var2);

    @PatchMapping(value={"/{id}"})
    public UserDto updateUserInfo(@PathVariable(value="id") String var1, @RequestBody UserDto var2);

    @PostMapping(value={"/password"})
    public UserDto updateUserPassword(@RequestParam(value="username") String var1, @RequestParam(value="password") String var2);

    @PostMapping(value={"/modify-pwd"})
    public BaseResultDto modifyUserPassword(@RequestParam(value="username") String var1, @RequestParam(value="password") String var2);

    @GetMapping(value={"/{id}"})
    public UserDto getUserDetail(@PathVariable(value="id") String var1);

    @Deprecated
    @GetMapping(value={"/username/{username}"})
    public UserDto getUserByUsername(@PathVariable(value="username") String var1);

    @GetMapping(value={"/username"})
    public UserDto getUserDetailByUsername(@RequestParam(value="username") String var1);

    @GetMapping(value={"/current-user"})
    public UserDto getCurrentUser();

    @PostMapping(value={"/{id}/enabled"})
    public Boolean enabledUser(@PathVariable(name="id") String var1);

    @PostMapping(value={"/{id}/disabled"})
    public Boolean disabledUser(@PathVariable(name="id") String var1);

    @PostMapping(value={"/{id}/onLeave"})
    public boolean userOnLeave(@PathVariable(name="id") String var1);

    @PostMapping(value={"/{id}/onDuty"})
    public boolean userOnDuty(@PathVariable(name="id") String var1);

    @PostMapping(value={"/{id}/onDuty-auth"})
    public boolean userOnDuty(@PathVariable(name="id") String var1, @RequestParam(name="operatorName", required=false) String var2);

    @DeleteMapping(value={"/{id}"})
    public Boolean deleteUser(@PathVariable(value="id") String var1);

    @DeleteMapping(value={"/usernames"})
    public BaseResultDto deleteByUserNames(@RequestParam(value="usernames") String var1);

    @PostMapping(value={"/{id}/sign"})
    public Boolean updateUserSign(@PathVariable(name="id") String var1, @RequestParam(name="signId") String var2);

    @GetMapping(value={"/sign"})
    public String getUserSign(@RequestParam(name="username") String var1);

    @PostMapping(value={"/username-list"})
    public List<UserDto> listUserByUserNames(@RequestBody List<String> var1);

    @PostMapping(value={"/id-list"})
    public List<UserDto> listUserByIds(@RequestBody List<String> var1);

    @PostMapping(value={"/{id}/roles"})
    public Boolean updateUserRoles(@PathVariable(value="id") String var1, @RequestBody List<String> var2);

    @PostMapping(value={"/{id}/orgs"})
    public Boolean updateUserOrgs(@PathVariable(value="id") String var1, @RequestBody List<String> var2);

    @GetMapping(value={"/{id}/all-roles"})
    public List<RoleDto> findAllRoles(@PathVariable(value="id") String var1);

    @GetMapping(value={"/{id}/roles"})
    public List<RoleDto> findRoles(@PathVariable(value="id") String var1);

    @GetMapping(value={"/{id}/orgs"})
    public List<OrganizationDto> findOrgs(@PathVariable(name="id") String var1);

    @Deprecated
    @GetMapping(value={"/root-orgs"})
    public List<OrganizationDto> findUserRootOrgs(@RequestParam(name="username") String var1);

    @GetMapping(value={"/grading-root-orgs"})
    public List<OrganizationDto> findUserGradingRootOrgs(@RequestParam(name="username") String var1, @RequestParam(name="enabled", required=false) Integer var2);

    @PostMapping(value={"/check-password"})
    public Boolean checkUserPassword(@RequestParam(name="password") String var1, @RequestParam(name="id") String var2);

    @PostMapping(value={"/init-password"})
    public Boolean initUserPassword(@RequestParam(name="id") String var1);

    @GetMapping(value={"/existed"})
    public Boolean checkUserExist(@RequestParam(name="username") String var1);

    @GetMapping(value={"/{id}/module-authority"})
    public AuthorityDto findUserModuleAuthority(@PathVariable(name="id") String var1, @RequestParam(name="moduleId") String var2);

    @PostMapping(value={"{id}/lock"})
    public Boolean lockUser(@PathVariable(name="id") String var1);

    @PostMapping(value={"{id}/unlock"})
    public Boolean unlockUser(@PathVariable(name="id") String var1);

    @PostMapping(value={"/sms"})
    public BaseResultDto sendSms(@RequestParam(name="username", required=false) String var1, @RequestParam(name="phone", required=false) String var2, @RequestParam(name="msgType") String var3);

    @GetMapping(value={"/sms-verify"})
    public BaseResultDto smsVerify(@RequestParam(name="username", required=false) String var1, @RequestParam(name="phone", required=false) String var2, @RequestParam(name="msgType") String var3, @RequestParam(name="code") String var4);

    @GetMapping(value={"/list/unSelect"})
    public Page<UserDto> queryUnaddUserList(@RequestParam(name="roleId") String var1, Pageable var2);

    @PostMapping(value={"/sign-ca"})
    public BaseResultDto signCa(@RequestParam(name="caType") String var1, @RequestParam(name="cert") String var2, @RequestParam(name="signData") String var3);

    @GetMapping(value={"/condition/username-role"})
    public List<UserDto> listUserByUsernameAndRoleIds(@RequestParam(name="username") String var1, @RequestParam(name="roleIds", required=false) String var2);

    @GetMapping(value={"/condition/role-region"})
    public List<UserDto> listUserByRoleIdsAndRegionCodes(@RequestParam(name="roleIds") String var1, @RequestParam(name="regionCodes") String var2);

    @GetMapping(value={"/no-sign"})
    public List<UserDto> findNoSignUsers();

    @GetMapping(value={"/list/initialPwd"})
    public List<UserDto> listInitialPwdUsers();

    @PostMapping(value={"/leave/addLeaveRecord-and-changeLeaveStatus"})
    public Boolean saveUserLeaveAndSetOnLeave(@RequestBody UserLeaveDto var1);

    @GetMapping(value={"/leave/records"})
    public Page<UserLeaveDto> listUserLeavesPage(Pageable var1, @RequestParam(name="enabled", required=false) String var2, @RequestParam(name="alias", required=false) String var3, @RequestParam(name="startLeaveOperatorName", required=false) String var4, @RequestParam(name="startTime", required=false) Long var5, @RequestParam(name="endTime", required=false) Long var6);
}

