package cn.gtmap.gtc.sso.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 描述:
 *
 * @author lenovo
 * @create 2020-08-20 10:01
 */
@Getter
@Setter
public class ThirdLoginConfigDto {

    /*
     *  主键
     * */
    private String id;

    /**
     * 第三方应用code码
     */
    private String code;

    //登录解析方式： 0： 回调第三方系统获取token/session 获取用户信息 1：根据token解析用户信息
    private Integer parseType = 0;

    /**
     * 第三方获取用户信息地址
     */
    private String oauthUrl;

    /**
     * 默认跳转地址
     */
    private String redirectUrl;

    private String usernameKey;

    private String errorRedirectUrl;

    //加密类型
    private String encType;

    // 传入的签名字段属性名称
    private String signParam;

    //加解密key
    private String authKey;

    //使用默认用户
    private String defUser;


    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateAt;


}
