package cn.gtmap.gtc.sso.domain.dto;

import java.io.Serializable;
import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2020-4-28
 * @description
 */

public class OrgUserDto implements Serializable {

    /*
     *  主键
     * */
    private String id;

    /*
     *  编码
     * */
    private String code;

    /*
     *  名称
     * */
    private String name;

    /*
     *  1 ：正常 0：禁用
     * */
    private int enabled;


    /*
     *  组织层级，0：最顶层
     * */
    private int weight;

    /*
     *  上一级组织主键
     * */
    private String parentId;

    /*
     *  上一级组织名称
     * */
    private String parentName;

    /*
     *  上一级组织编码
     * */
    private String parentCode;

    /**
     * 排序字段
     */
    private int sort;

    /*
     *  是否拥有子集， 根据ztree 定义
     * */
    private boolean isParent;

    /*
    *  组织下部分人员
    * */
    private List<UserDto> userDtos;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getEnabled() {
        return enabled;
    }

    public void setEnabled(int enabled) {
        this.enabled = enabled;
    }

    public int getWeight() {
        return weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public boolean getIsParent() {
        return isParent;
    }

    public void setIsParent(boolean isParent) {
        this.isParent = isParent;
    }


    public int getSort() {
        return sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }


    public List<UserDto> getUserDtos() {
        return userDtos;
    }

    public void setUserDtos(List<UserDto> userDtos) {
        this.userDtos = userDtos;
    }

}
