package cn.gtmap.gtc.sso.domain.dto;

import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2020-4-2
 * @description  数据鉴权返回结果
 */

@NoArgsConstructor
public class DataAccessDto implements Serializable {

    // 0 成功， 1 失败
    private int code;

    private String message;

    private String authorities = "";

    private UserDto userDto;

    public DataAccessDto(int code, String message, String authorities) {
        this.code = code;
        this.message = message;
        this.authorities = authorities;
    }

    public int getCode() {
        return code;
    }

    public DataAccessDto setCode(int code) {
        this.code = code;
        return this;
    }

    public String getAuthorities() {
        return authorities;
    }

    public DataAccessDto setAuthorities(String authorities) {
        this.authorities = authorities;
        return this;
    }

    public String getMessage() {
        return message;
    }

    public DataAccessDto setMessage(String message) {
        this.message = message;
        return this;
    }

    public UserDto getUserDto() {
        return userDto;
    }

    public DataAccessDto setUserDto(UserDto userDto) {
        this.userDto = userDto;
        return this;
    }
}
