package cn.gtmap.gtc.sso.domain.dto;

import lombok.Getter;
import lombok.Setter;
import org.springframework.util.StringUtils;

import java.io.Serializable;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/12/4
 * @description
 */

@Getter
@Setter
public class ConfigureDto implements Serializable {

    private static final long serialVersionUID = -7112232992043267734L;
    private String id;

    private String code = "default";


    /*
     *  关闭当前用户所有登陆终端session
     *  1： 关闭  0：不关闭
     */
    private int invalidSessions = 0;

    /*
     *  允许登录失败的次数*
     */
    private int loginFailTimePermit = 10;

    /*
     *  登录失败次数自动清0时间(单位：小时)*
     */
    private int failTimeReset = 12;

    /*
     *  时间单位
     */
    private String failTimeResetUnit = "H";

    /*
     *  登录后跳转到默认页面*
     */
    private String loginSuccessUrl;

    /*
     *  默认登陆页面编码*
     */
    private String loginModel = "default";

    /*
     *  短信验证有效时间 s
     */
    private Integer smsValidTime = 300;

    /*
     *  是否提示修改密码 s
     */
    private String modifyPwd = "N";

    /*
     *  判断离线时间 s
     */
    private Integer offlineTime;

    /*
     *  公网登陆跳转页面*
     */
    private String publicSuccessUrl;

    /*
     *  public 登陆模型
     */
    private String publicLoginModel;

    /*
     *  CA认证地址
     */
    private String caServer;

    /*
     *  CA 类型
     * */
    public String caType;

    public String getFailTimeResetUnit() {
        if (StringUtils.isEmpty(this.failTimeResetUnit)) {
            return "H";
        }
        return failTimeResetUnit;
    }

    public void setFailTimeResetUnit(String failTimeResetUnit) {
        this.failTimeResetUnit = failTimeResetUnit;
    }
}
