package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.MultiLoginConfigDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

@FeignClient(name = "account")
@RequestMapping("/account/rest/v1/multi-login-config")
public interface MultiLoginConfigManagerClient {


    @PostMapping
    MultiLoginConfigDto createMultiLoginConfigure(@RequestBody MultiLoginConfigDto multiLoginConfigDto);

    @PutMapping
    MultiLoginConfigDto updateMultiLoginConfigure(@RequestBody MultiLoginConfigDto multiLoginConfigDto);

    @GetMapping("/{id}")
    MultiLoginConfigDto findById(@PathVariable(name = "id") String id);

    @DeleteMapping("/{id}")
    boolean deleteById(@PathVariable(name = "id") String id);

    @GetMapping("/page")
    Page<MultiLoginConfigDto> listMultiLoginConfig(Pageable pageable, @RequestParam(name = "matchType", required = false) String matchType, @RequestParam(name = "matchValue", required = false) String matchValue);
}
