package cn.gtmap.gtc.clients;

import cn.gtmap.gtc.sso.domain.dto.ConfigureDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/12/4
 * @description
 */

@FeignClient(name = "account")
@RequestMapping("/account/rest/v1/configure")
public interface ConfigManagerClient {

    /**
     * @param  configureDto 配置
     * @return
     * @description 更新配置
     */
    @PostMapping
    ConfigureDto saveConfigure(@RequestBody ConfigureDto configureDto);

    /**
     * @param
     * @return
     * @description 获取配置
     */
    @GetMapping
    ConfigureDto getConfigure();
}
