/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.storage.clients.v1;

import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.storage.domain.dto.BaseResultDto;
import cn.gtmap.gtc.storage.domain.dto.MultipartDto;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="${app.services.storage-app:storage-app}")
@RequestMapping(value={"/storage/rest/v1/storages"})
public interface StorageClient {
    @PostMapping(value={"/folder"})
    public StorageDto createFolder(@RequestParam(name="clientId", required=false) String var1, @RequestParam(name="spaceId", required=false) String var2, @RequestParam(name="nodeId", required=false) String var3, @RequestParam(name="name") String var4, @RequestParam(name="owner") String var5);

    @PostMapping(value={"/root/folder"})
    public StorageDto createRootFolder(@RequestParam(name="clientId", required=false) String var1, @RequestParam(name="spaceId", required=false) String var2, @RequestParam(name="name") String var3, @RequestParam(name="owner", required=false) String var4);

    @GetMapping(value={"/menus"})
    public List<StorageDto> queryMenus(@RequestParam(name="clientId", required=false) String var1, @RequestParam(name="spaceId", required=false) String var2, @RequestParam(name="nodeId", required=false) String var3, @RequestParam(name="enabled", required=false) Integer var4, @RequestParam(name="type", required=false) Integer var5);

    @GetMapping(value={"/existence"})
    public boolean checkExist(@RequestParam(name="clientId", required=false) String var1, @RequestParam(name="spaceId", required=false) String var2, @RequestParam(name="nodeId", required=false) String var3, @RequestParam(name="name") String var4, @RequestParam(name="owner", required=false) String var5, @RequestParam(name="type", required=false) Integer var6);

    @PostMapping(value={"/status"})
    public boolean changeStatus(@RequestParam(name="id") String var1, @RequestParam(name="enabled") Integer var2);

    @PostMapping(value={"/rename/{id}"})
    public boolean rename(@PathVariable(name="id") String var1, @RequestParam(name="name") String var2);

    @DeleteMapping
    public boolean deleteStorages(@RequestBody List<String> var1);

    @PostMapping(value={"/list"})
    public List<StorageDto> listStoragesByIds(@RequestBody List<String> var1);

    @GetMapping(value={"/{id}"})
    public StorageDto findById(@PathVariable(name="id") String var1);

    @GetMapping(value={"/root"})
    public PageResult<StorageDto> listRootStorages(Pageable var1, @RequestParam(name="clientId", required=false) String var2, @RequestParam(name="spaceId", required=false) String var3, @RequestParam(name="owner", required=false) String var4, @RequestParam(name="name", required=false) String var5, @RequestParam(name="enabled", required=false) Integer var6, @RequestParam(name="type", required=false) Integer var7);

    @GetMapping(value={"/mime"})
    public PageResult<StorageDto> listMimeStorages(Pageable var1, @RequestParam(name="clientId", required=false) String var2, @RequestParam(name="spaceId", required=false) String var3, @RequestParam(name="owner", required=false) String var4, @RequestParam(name="name", required=false) String var5, @RequestParam(name="enabled", required=false) Integer var6, @RequestParam(name="type", required=false) Integer var7);

    @GetMapping(value={"/project/root"})
    @Deprecated
    public PageResult<StorageDto> listProjectStorages(Pageable var1, @RequestParam(name="spaceId", required=false) String var2, @RequestParam(name="proId", required=false) String var3, @RequestParam(name="owner", required=false) String var4, @RequestParam(name="name", required=false) String var5, @RequestParam(name="enabled", required=false) Integer var6, @RequestParam(name="type", required=false) Integer var7);

    @GetMapping(value={"/subset"})
    public PageResult<StorageDto> listSubsetStorages(Pageable var1, @RequestParam(name="id") String var2, @RequestParam(name="name", required=false) String var3, @RequestParam(name="enabled", required=false) Integer var4, @RequestParam(name="type", required=false) Integer var5);

    @GetMapping(value={"/all/root"})
    public List<StorageDto> listAllRootStorages(@RequestParam(name="clientId", required=false) String var1, @RequestParam(name="spaceId", required=false) String var2, @RequestParam(name="owner", required=false) String var3, @RequestParam(name="name", required=false) String var4, @RequestParam(name="enabled", required=false) Integer var5, @RequestParam(name="type", required=false) Integer var6);

    @GetMapping(value={"/all/subset"})
    public List<StorageDto> listAllSubsetStorages(@RequestParam(name="id") String var1, @RequestParam(name="name", required=false) String var2, @RequestParam(name="enabled", required=false) Integer var3, @RequestParam(name="type", required=false) Integer var4);

    @GetMapping(value={"/name"})
    public List<StorageDto> listStoragesByName(@RequestParam(name="clientId", required=false) String var1, @RequestParam(name="spaceId", required=false) String var2, @RequestParam(name="owner", required=false) String var3, @RequestParam(name="name") String var4, @RequestParam(name="enabled", required=false) Integer var5, @RequestParam(name="type", required=false) Integer var6);

    @GetMapping(value={"/{id}/node-path"})
    public List<StorageDto> getNodePath(@PathVariable(name="id") String var1);

    @PostMapping(value={"/multipart/upload"})
    public StorageDto multipartUpload(@RequestBody MultipartDto var1);

    @PostMapping(value={"/replace/upload"})
    public StorageDto replaceUpload(@RequestParam(name="id") String var1, @RequestBody MultipartDto var2);

    @GetMapping(value={"/count"})
    public long getFileCount(@RequestParam(name="clientId", required=false) String var1, @RequestParam(name="spaceId", required=false) String var2, @RequestParam(name="owner", required=false) String var3, @RequestParam(name="nodeId", required=false) String var4, @RequestParam(name="enabled", required=false) Integer var5, @RequestParam(name="type", required=false) Integer var6, @RequestParam(name="subpath", required=false) Integer var7);

    @PostMapping(value={"/folders/count"})
    public Map<String, Long> getFoldersCount(@RequestBody List<String> var1, @RequestParam(name="owner", required=false) String var2, @RequestParam(name="enabled", required=false) Integer var3, @RequestParam(name="type", required=false) Integer var4, @RequestParam(name="subpath", required=false) Integer var5);

    @CrossOrigin
    @GetMapping(value={"/zip"})
    public StorageDto zipStorages(@RequestParam(name="ids") String var1, @RequestParam(name="name", required=false) String var2, @RequestParam(name="owner") String var3, @RequestParam(name="nodeId", required=false) String var4);

    @GetMapping(value={"/user-sign"})
    public String userSign(@RequestParam(name="username") String var1);

    @PutMapping(value={"/move"})
    public BaseResultDto moveStorages(@RequestParam(name="nodeId") String var1, @RequestBody List<String> var2);

    @GetMapping(value={"/download/base64"})
    public BaseResultDto downloadBase64(@RequestParam(name="id") String var1);

    @GetMapping(value={"/download"})
    public MultipartDto download(@RequestParam(name="id") String var1);
}

